/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.mixin;

import com.google.common.collect.Lists;
import dev.ultimatchamp.enhancedtooltips.config.EnhancedTooltipsConfig;
import dev.ultimatchamp.enhancedtooltips.mixin.accessors.PlayerInventoryAccessor;
import dev.ultimatchamp.enhancedtooltips.tooltip.TooltipHelper;
import dev.ultimatchamp.enhancedtooltips.tooltip.TooltipItemStackCache;
import dev.ultimatchamp.enhancedtooltips.util.BadgesUtils;
import dev.ultimatchamp.enhancedtooltips.util.EnhancedTooltipsTextVisitor;
import dev.ultimatchamp.enhancedtooltips.util.MatricesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.class_10124;
import net.minecraft.class_10132;
import net.minecraft.class_10134;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_4174;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.joml.Quaternionfc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public abstract class InGameHudMixin {
    @Unique
    private long enhancedTooltips$tiltStartTime = 0L;
    @Unique
    private int enhancedTooltips$lastTiltSlot = -1;
    @Unique
    private float enhancedTooltips$tiltDirection = 0.0f;
    @Unique
    private static final int enhancedTooltips$SPACING = 4;
    @Shadow
    private class_1799 field_2031;
    @Shadow
    @Final
    private class_310 field_2035;
    @Shadow
    private int field_2040;

    @Shadow
    public abstract class_327 method_1756();

    @Inject(method={"renderHeldItemTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTextWithBackground(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;IIII)I")}, cancellable=true)
    private void enhancedTooltips$renderHeldItemTooltipBackground(class_332 context, CallbackInfo ci) {
        float alpha;
        int currentSlot;
        List tooltip;
        EnhancedTooltipsConfig config = EnhancedTooltipsConfig.load();
        if (config.heldItemTooltip.mode == EnhancedTooltipsConfig.HeldItemTooltipMode.OFF) {
            return;
        }
        if (config.heldItemTooltip.mode == EnhancedTooltipsConfig.HeldItemTooltipMode.ON) {
            tooltip = class_437.method_25408((class_310)this.field_2035, (class_1799)this.field_2031);
            TooltipItemStackCache.saveItemStack(class_1799.field_8037);
            if (tooltip.isEmpty()) {
                return;
            }
        } else {
            tooltip = Lists.newArrayList((Object[])new class_2561[]{TooltipHelper.getDisplayName(this.field_2031)});
        }
        class_327 textRenderer = this.method_1756();
        int n = currentSlot = this.field_2035.field_1724 != null ? ((PlayerInventoryAccessor)this.field_2035.field_1724.method_31548()).getSelectedSlot() : this.enhancedTooltips$lastTiltSlot;
        if (currentSlot != this.enhancedTooltips$lastTiltSlot) {
            int delta = currentSlot - this.enhancedTooltips$lastTiltSlot;
            if (this.enhancedTooltips$lastTiltSlot == 8 && currentSlot == 0) {
                delta = 1;
            } else if (this.enhancedTooltips$lastTiltSlot == 0 && currentSlot == 8) {
                delta = -1;
            }
            this.enhancedTooltips$tiltDirection = Math.signum(delta);
            this.enhancedTooltips$tiltStartTime = System.currentTimeMillis();
            this.enhancedTooltips$lastTiltSlot = currentSlot;
        }
        class_3545<class_2561, Integer> badgeText = BadgesUtils.getBadgeText(this.field_2031);
        if (config.general.itemBadges && !((class_2561)badgeText.method_15442()).method_44746().isEmpty()) {
            class_5250 name = ((class_2561)tooltip.getFirst()).method_27661().method_10852((class_2561)class_2561.method_43470((String)" (").method_54663(-4539718)).method_10852((class_2561)((class_2561)badgeText.method_15442()).method_27661().method_54663(((Integer)badgeText.method_15441()).intValue())).method_10852((class_2561)class_2561.method_43470((String)")").method_54663(-4539718));
            tooltip.set(0, name);
        }
        if (config.general.rarityTooltip) {
            tooltip.add(1, TooltipHelper.getRarityName(this.field_2031));
        }
        if (config.heldItemTooltip.mode == EnhancedTooltipsConfig.HeldItemTooltipMode.ON) {
            this.enhancedTooltips$addFoodTooltip(tooltip::add);
        }
        if (this.field_2035.field_1690.field_1827) {
            tooltip.remove(class_2561.method_43469((String)"item.durability", (Object[])new Object[]{this.field_2031.method_7936() - this.field_2031.method_7919(), this.field_2031.method_7936()}));
            tooltip.remove(class_2561.method_43470((String)class_7923.field_41178.method_10221((Object)this.field_2031.method_7909()).toString()).method_27692(class_124.field_1063));
            tooltip.remove(class_2561.method_43469((String)"item.components", (Object[])new Object[]{this.field_2031.method_57353().method_57835()}).method_27692(class_124.field_1063));
        }
        if ((!config.durability.durabilityTooltip.equals((Object)EnhancedTooltipsConfig.DurabilityTooltipMode.OFF) || config.durability.durabilityBar) && this.field_2031.method_7963()) {
            tooltip.add(class_2561.method_43471((String)"enhancedtooltips.tooltip.durability").method_10852(this.enhancedTooltips$getDurabilityText()));
        }
        float scale = config.heldItemTooltip.scaleFactor;
        float maxWidth = (float)context.method_51421() / (2.0f * scale);
        for (class_2561 component : new ArrayList(tooltip)) {
            if (!((float)textRenderer.method_27525((class_5348)component) > maxWidth)) continue;
            ArrayList wrapped = new ArrayList();
            textRenderer.method_1728((class_5348)component, (int)maxWidth).forEach(line -> wrapped.add(EnhancedTooltipsTextVisitor.get(line)));
            tooltip.addAll(tooltip.indexOf(component), wrapped);
            tooltip.remove(component);
        }
        AtomicInteger cutOff = new AtomicInteger();
        tooltip.removeIf(text -> {
            if (tooltip.indexOf(text) > config.heldItemTooltip.maxLines) {
                cutOff.incrementAndGet();
                return true;
            }
            return textRenderer.method_27525((class_5348)text) == 0;
        });
        if (cutOff.get() > 0) {
            tooltip.add(class_2561.method_43470((String)("(+" + cutOff.get() + " more...)")).method_54663(-4539718).method_27694(s -> s.method_10978(Boolean.valueOf(true))));
        }
        int width = tooltip.stream().mapToInt(arg_0 -> ((class_327)textRenderer).method_27525(arg_0)).max().orElse(0);
        float x = ((float)context.method_51421() - (float)width * scale) / 2.0f;
        float y = context.method_51443() - 59;
        Objects.requireNonNull(textRenderer);
        y -= (9.0f + 2.0f) * (float)tooltip.size() * scale - 12.0f + 2.0f;
        if (this.field_2035.field_1724.method_6096() > 0 && this.field_2035.field_1761 != null && this.field_2035.field_1761.method_2908()) {
            y -= 8.0f;
        }
        if ((alpha = (float)(this.field_2040 * 256) / 10.0f) > 255.0f) {
            alpha = 255.0f;
        }
        MatricesUtil matrices = new MatricesUtil(context.method_51448());
        matrices.pushMatrix();
        this.enhancedTooltips$drawTextWithBackground(textRenderer, tooltip, (int)x, (int)y, width, context, (int)alpha, scale);
        matrices.popMatrix();
        ci.cancel();
    }

    @Unique
    public void enhancedTooltips$addFoodTooltip(Consumer<class_2561> list) {
        class_10124 consumableComponent;
        class_4174 foodComponent = this.enhancedTooltips$getFoodComponent();
        if (foodComponent == null) {
            return;
        }
        int hunger = this.enhancedTooltips$getHunger();
        int saturation = this.enhancedTooltips$getSaturation();
        class_5250 hungerText = class_2561.method_43471((String)"enhancedtooltips.tooltip.hunger").method_27693(" " + hunger + " ").method_10852((class_2561)class_2561.method_43471((String)"effect.minecraft.hunger"));
        class_5250 saturationText = class_2561.method_43469((String)"enhancedtooltips.tooltip.saturation", (Object[])new Object[]{saturation}).method_54663(-16711681);
        if (EnhancedTooltipsConfig.load().foodAndDrinks.hungerTooltip) {
            list.accept((class_2561)hungerText);
        }
        if (EnhancedTooltipsConfig.load().foodAndDrinks.saturationTooltip) {
            list.accept((class_2561)saturationText);
        }
        if ((consumableComponent = this.enhancedTooltips$getConsumableComponent()) == null) {
            return;
        }
        List effects = consumableComponent.comp_3089();
        for (class_10134 entry : effects) {
            if (EnhancedTooltipsConfig.load().foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.OFF) break;
            if (!(entry instanceof class_10132)) continue;
            class_10132 applyEffectsConsumeEffect = (class_10132)entry;
            for (class_1293 statusEffect : applyEffectsConsumeEffect.comp_3094()) {
                int c = ((class_1291)statusEffect.method_5579().comp_349()).method_5556();
                class_5250 effectText = class_2561.method_43470((String)"\u25c8 ").method_10852((class_2561)class_2561.method_43471((String)statusEffect.method_5586())).method_27693(" (").method_10852(class_1292.method_5577((class_1293)statusEffect, (float)1.0f, (float)20.0f)).method_27693(")").method_54663(c);
                float probability = applyEffectsConsumeEffect.comp_3095();
                if (!(probability >= 1.0f)) {
                    effectText = effectText.method_27693(" [").method_27693(Math.round(probability * 100.0f) + "%").method_27693("]");
                }
                list.accept((class_2561)effectText);
            }
        }
    }

    @Unique
    public class_4174 enhancedTooltips$getFoodComponent() {
        class_4174 foodComponent = (class_4174)this.field_2031.method_7909().method_57347().method_58694(class_9334.field_50075);
        return foodComponent;
    }

    @Unique
    public class_10124 enhancedTooltips$getConsumableComponent() {
        return (class_10124)this.field_2031.method_58694(class_9334.field_53964);
    }

    @Unique
    public int enhancedTooltips$getHunger() {
        class_4174 foodComponent = this.enhancedTooltips$getFoodComponent();
        int hunger = 0;
        class_10124 consumableComponent = this.enhancedTooltips$getConsumableComponent();
        if (foodComponent != null && consumableComponent != null) {
            hunger = foodComponent.comp_2491();
        }
        return hunger;
    }

    @Unique
    public int enhancedTooltips$getSaturation() {
        class_4174 foodComponent = this.enhancedTooltips$getFoodComponent();
        int saturation = 0;
        int hunger = this.enhancedTooltips$getHunger();
        if (foodComponent != null) {
            saturation = (int)((double)foodComponent.comp_2492() / ((double)hunger * 2.0) * 100.0);
        }
        return saturation;
    }

    @Unique
    private class_2561 enhancedTooltips$getDurabilityText() {
        int remaining = this.field_2031.method_7936() - this.field_2031.method_7919();
        if (remaining <= 0) {
            return class_2561.method_43473();
        }
        return switch (EnhancedTooltipsConfig.load().durability.durabilityTooltip) {
            case EnhancedTooltipsConfig.DurabilityTooltipMode.VALUE -> class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(remaining)).method_10862(class_2583.field_24360.method_36139(this.field_2031.method_31580()))).method_10852((class_2561)class_2561.method_43470((String)" / ").method_10862(class_2583.field_24360.method_36139(-4539718))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.field_2031.method_7936())).method_10862(class_2583.field_24360.method_36139(-16711936)));
            case EnhancedTooltipsConfig.DurabilityTooltipMode.PERCENTAGE -> {
                int percent = remaining * 100 / this.field_2031.method_7936();
                yield class_2561.method_43470((String)(" " + percent + "%")).method_10862(class_2583.field_24360.method_36139(this.field_2031.method_31580()));
            }
            default -> {
                int i;
                int filledCount = remaining * 10 / this.field_2031.method_7936();
                class_5250 durabilityBar = class_2561.method_43470((String)" ");
                for (i = 0; i < filledCount; ++i) {
                    durabilityBar.method_10852((class_2561)class_2561.method_43470((String)"=").method_10862(class_2583.field_24360.method_36139(this.field_2031.method_31580())));
                }
                for (i = filledCount; i < 10; ++i) {
                    durabilityBar.method_10852((class_2561)class_2561.method_43470((String)"=").method_10862(class_2583.field_24360.method_36139(-4539718)));
                }
                yield durabilityBar;
            }
        };
    }

    @Unique
    private void enhancedTooltips$drawTextWithBackground(class_327 textRenderer, List<class_2561> lines, int x, int y, int width, class_332 context, int alpha, float scale) {
        int bgAlpha = 128 * alpha / 255 << 24;
        float tilt = this.enhancedTooltips$getTilt();
        MatricesUtil matrices = new MatricesUtil(context.method_51448());
        matrices.pushMatrix();
        float f = (float)x + (float)width * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(textRenderer);
        matrices.trans(f, f2 + (float)(9 * lines.size()) * scale / 2.0f, 0.0f);
        matrices.scal(scale, scale, 0.0f);
        context.method_51448().method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(tilt));
        float f3 = -((float)x / scale + (float)width / 2.0f);
        float f4 = (float)y / scale;
        Objects.requireNonNull(textRenderer);
        matrices.trans(f3, -(f4 + (float)(9 * lines.size()) / 2.0f), 0.0f);
        if (EnhancedTooltipsConfig.load().heldItemTooltip.showBackground) {
            int n = (int)((float)x / scale - 4.0f + 1.0f);
            int n2 = (int)((float)y / scale - 2.0f);
            int n3 = (int)((float)x / scale + (float)width + 4.0f - 1.0f);
            float f5 = (float)y / scale;
            Objects.requireNonNull(textRenderer);
            context.method_25294(n, n2, n3, (int)(f5 + (9.0f + 2.0f) * (float)lines.size() - 2.0f), bgAlpha);
        }
        int textY = (int)((float)y / scale);
        for (class_2561 line : lines) {
            int color = (line.method_10866().method_10973() != null ? line.method_10866().method_10973().method_27716() : 0xFFFFFF) | alpha << 24;
            context.method_51439(textRenderer, (class_2561)line.method_27661().method_54663(color), (int)(((float)context.method_51421() / scale - (float)textRenderer.method_27525((class_5348)line)) / 2.0f), textY, color, true);
            Objects.requireNonNull(textRenderer);
            textY += 9 + 2;
        }
        int frameAlpha = 112 * alpha / 255 << 24;
        if (EnhancedTooltipsConfig.load().heldItemTooltip.showBackground) {
            int n = (int)((float)x / scale - 4.0f);
            int n4 = (int)((float)y / scale - 2.0f);
            Objects.requireNonNull(textRenderer);
            BadgesUtils.drawFrame(context, n, n4, width + 8, (9 + 2) * lines.size() + 2, 400, frameAlpha);
        }
        matrices.popMatrix();
    }

    @Unique
    private float enhancedTooltips$getTilt() {
        float duration;
        if (!EnhancedTooltipsConfig.load().heldItemTooltip.tiltAnimation || this.enhancedTooltips$tiltDirection == 0.0f) {
            return 0.0f;
        }
        long elapsed = System.currentTimeMillis() - this.enhancedTooltips$tiltStartTime;
        if ((float)elapsed > (duration = (float)EnhancedTooltipsConfig.load().heldItemTooltip.tiltDuration)) {
            return 0.0f;
        }
        float eased = (float)Math.pow(1.0f - (float)elapsed / duration, EnhancedTooltipsConfig.load().heldItemTooltip.tiltEasing);
        return this.enhancedTooltips$tiltDirection * EnhancedTooltipsConfig.load().heldItemTooltip.tiltMagnitude * eased;
    }
}

