/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;

public record ArmorTooltipComponent(ItemStack stack) implements ClientTooltipComponent
{
    public int getHeight() {
        ArmorItem armor;
        Item item;
        ItemAttributeModifiers c;
        int height = 0;
        if (((ArmorStand)EntityType.ARMOR_STAND.create((Level)Minecraft.getInstance().level)).getEquipmentSlotForItem(this.stack).getType() == EquipmentSlot.Type.HUMANOID_ARMOR && (c = (ItemAttributeModifiers)this.stack.get(DataComponents.ATTRIBUTE_MODIFIERS)) != null && (item = this.stack.getItem()) instanceof ArmorItem && (armor = (ArmorItem)item).getDefense() > 0) {
            height = 9;
        }
        return height;
    }

    public int getWidth(Font textRenderer) {
        ItemAttributeModifiers c;
        int width = 0;
        if (((ArmorStand)EntityType.ARMOR_STAND.create((Level)Minecraft.getInstance().level)).getEquipmentSlotForItem(this.stack).getType() == EquipmentSlot.Type.HUMANOID_ARMOR && (c = (ItemAttributeModifiers)this.stack.get(DataComponents.ATTRIBUTE_MODIFIERS)) != null) {
            ArmorItem armor;
            Item item = this.stack.getItem();
            if (!(item instanceof ArmorItem) || (armor = (ArmorItem)item).getDefense() < 0) {
                return 0;
            }
            int prot = armor.getDefense();
            width += prot / 2 * 9;
        }
        return width;
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        ItemAttributeModifiers c;
        if (((ArmorStand)EntityType.ARMOR_STAND.create((Level)Minecraft.getInstance().level)).getEquipmentSlotForItem(this.stack).getType() == EquipmentSlot.Type.HUMANOID_ARMOR && (c = (ItemAttributeModifiers)this.stack.get(DataComponents.ATTRIBUTE_MODIFIERS)) != null) {
            Item item = this.stack.getItem();
            if (!(item instanceof ArmorItem)) {
                return;
            }
            ArmorItem armor = (ArmorItem)item;
            int prot = armor.getDefense();
            for (int j = 0; j < prot / 2; ++j) {
                ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)"hud/armor_full");
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.blitSprite(resourceLocation, x + j * 9, y, 9, 9);
            }
            if (prot % 2 == 1) {
                ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)"hud/armor_half");
                int n = x + prot / 2 * 9;
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.blitSprite(resourceLocation, n, y, 9, 9);
            }
        }
    }
}

