/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import dev.ultimatchamp.enhancedtooltips.config.EnhancedTooltipsConfig;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;

public class FoodTooltipComponent
implements ClientTooltipComponent {
    private final ItemStack stack;
    private final EnhancedTooltipsConfig config;

    public FoodTooltipComponent(ItemStack stack) {
        this.stack = stack;
        this.config = EnhancedTooltipsConfig.load();
    }

    public static FoodProperties getFoodComponent(ItemStack stack) {
        FoodProperties foodComponent = (FoodProperties)stack.getItem().components().get(DataComponents.FOOD);
        return foodComponent;
    }

    public int getHunger() {
        FoodProperties foodComponent = FoodTooltipComponent.getFoodComponent(this.stack);
        int hunger = 0;
        if (foodComponent != null) {
            hunger = foodComponent.nutrition();
        }
        return hunger;
    }

    public int getSaturation() {
        FoodProperties foodComponent = FoodTooltipComponent.getFoodComponent(this.stack);
        int saturation = 0;
        int hunger = this.getHunger();
        if (foodComponent != null) {
            saturation = (int)((double)foodComponent.saturation() / ((double)hunger * 2.0) * 100.0);
        }
        return saturation;
    }

    public int getHeight() {
        int height = 0;
        FoodProperties foodComponent = FoodTooltipComponent.getFoodComponent(this.stack);
        if (foodComponent != null) {
            if (this.config.foodAndDrinks.hungerTooltip) {
                height += 10;
            }
            if (this.config.foodAndDrinks.saturationTooltip) {
                height += 10;
            }
            if (this.config.foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.OFF) {
                return height;
            }
            for (FoodProperties.PossibleEffect entry : foodComponent.effects()) {
                height += 10;
            }
        }
        return height;
    }

    public int getWidth(Font textRenderer) {
        int foodWidth = 0;
        int effectsWidth = 0;
        FoodProperties foodComponent = FoodTooltipComponent.getFoodComponent(this.stack);
        int hunger = this.getHunger();
        int hungerLine = 0;
        if (this.config.foodAndDrinks.hungerTooltip) {
            float f = textRenderer.width((FormattedText)Component.translatable((String)"enhancedtooltips.tooltip.hunger")) + 1;
            Objects.requireNonNull(textRenderer);
            hungerLine = (int)(f + (float)(9 - 2) * ((float)hunger / 2.0f));
        }
        int saturationLine = 0;
        if (this.config.foodAndDrinks.saturationTooltip) {
            saturationLine = textRenderer.width((FormattedText)Component.translatable((String)"enhancedtooltips.tooltip.saturation"));
        }
        foodWidth = Math.max(hungerLine, saturationLine);
        if (this.config.foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.OFF) {
            return foodWidth;
        }
        if (foodComponent == null) {
            return 0;
        }
        for (FoodProperties.PossibleEffect entry : foodComponent.effects()) {
            effectsWidth = Math.max(effectsWidth, textRenderer.width((FormattedText)Component.translatable((String)entry.effect().getDescriptionId()).append(" (99:99)")));
        }
        if (effectsWidth != 0 && this.config.foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.WITH_ICONS) {
            Objects.requireNonNull(textRenderer);
            effectsWidth += 9 + 3;
        }
        return Math.max(foodWidth, effectsWidth);
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        FoodProperties foodComponent = FoodTooltipComponent.getFoodComponent(this.stack);
        int hunger = this.getHunger();
        int saturation = this.getSaturation();
        if (foodComponent == null) {
            return;
        }
        MutableComponent hungerText = Component.translatable((String)"enhancedtooltips.tooltip.hunger");
        MutableComponent saturationText = Component.translatable((String)"enhancedtooltips.tooltip.saturation", (Object[])new Object[]{saturation});
        int lineY = y;
        if (this.config.foodAndDrinks.hungerTooltip) {
            context.drawString(textRenderer, (Component)hungerText, x, lineY, -1, true);
            ResourceLocation fullHunger = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"hud/food_full");
            ResourceLocation halfHunger = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"hud/food_half");
            float fullHungers = (float)hunger / 2.0f;
            boolean hasHalfHunger = hunger % 2 != 0;
            int hungerWidth = textRenderer.width((FormattedText)hungerText) + 1;
            for (int i = 0; i < (int)fullHungers; ++i) {
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.blitSprite(fullHunger, x + hungerWidth, lineY, 9, 9);
                Objects.requireNonNull(textRenderer);
                hungerWidth += 9 - 2;
            }
            if (hasHalfHunger) {
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.blitSprite(halfHunger, x + hungerWidth, lineY, 9, 9);
            }
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
        if (this.config.foodAndDrinks.saturationTooltip) {
            context.drawString(textRenderer, (Component)saturationText, x + 2, lineY, -16711681, true);
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
        if (this.config.foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.OFF) {
            return;
        }
        for (FoodProperties.PossibleEffect entry : foodComponent.effects()) {
            MobEffectInstance statusEffect = entry.effect();
            int c = ((MobEffect)statusEffect.getEffect().value()).getColor();
            TextureAtlasSprite effectTexture = Minecraft.getInstance().getMobEffectTextures().get(statusEffect.getEffect());
            float probability = entry.probability();
            MutableComponent effectText = probability >= 1.0f ? Component.translatable((String)statusEffect.getDescriptionId()).append(" (").append(MobEffectUtil.formatDuration((MobEffectInstance)statusEffect, (float)1.0f, (float)20.0f)).append(")") : Component.translatable((String)statusEffect.getDescriptionId()).append(" (").append(MobEffectUtil.formatDuration((MobEffectInstance)statusEffect, (float)1.0f, (float)20.0f)).append(")").append(" [").append(Math.round(probability * 100.0f) + "%").append("]");
            if (this.config.foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.WITH_ICONS) {
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.blit(x, lineY - 1, 0, 9, 9, effectTexture);
                Objects.requireNonNull(textRenderer);
                context.drawString(textRenderer, (Component)effectText, x + 9 + 3, lineY, c, true);
            } else {
                context.drawString(textRenderer, (Component)effectText, x, lineY, c, true);
            }
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
    }
}

