/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import dev.ultimatchamp.enhancedtooltips.util.MatricesUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public record MapTooltipComponent(ItemStack stack) implements ClientTooltipComponent
{
    public int getHeight() {
        return 130;
    }

    public int getWidth(Font textRenderer) {
        return 128;
    }

    public void renderImage(Font textRenderer, int x, int y, GuiGraphics context) {
        MultiBufferSource.BufferSource vertexConsumers = Minecraft.getInstance().renderBuffers().bufferSource();
        MapRenderer mapRenderer = Minecraft.getInstance().gameRenderer.getMapRenderer();
        MapId mapId = (MapId)this.stack.get(DataComponents.MAP_ID);
        MapItemSavedData mapState = MapItem.getSavedData((ItemStack)this.stack, (Level)Minecraft.getInstance().level);
        if (mapState == null) {
            return;
        }
        MatricesUtil matrices = new MatricesUtil(context.pose());
        matrices.pushMatrix();
        matrices.trans(x, y, 0.0f);
        matrices.scal(1.0f, 1.0f, 0.0f);
        mapRenderer.update(mapId, mapState);
        mapRenderer.render(context.pose(), (MultiBufferSource)vertexConsumers, mapId, mapState, false, 0xF000F0);
        matrices.popMatrix();
    }
}

