/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.mixin;

import com.google.common.collect.Lists;
import com.mojang.math.Axis;
import dev.ultimatchamp.enhancedtooltips.config.EnhancedTooltipsConfig;
import dev.ultimatchamp.enhancedtooltips.mixin.accessors.PlayerInventoryAccessor;
import dev.ultimatchamp.enhancedtooltips.tooltip.TooltipHelper;
import dev.ultimatchamp.enhancedtooltips.tooltip.TooltipItemStackCache;
import dev.ultimatchamp.enhancedtooltips.util.BadgesUtils;
import dev.ultimatchamp.enhancedtooltips.util.EnhancedTooltipsTextVisitor;
import dev.ultimatchamp.enhancedtooltips.util.MatricesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class InGameHudMixin {
    @Unique
    private long enhancedTooltips$tiltStartTime = 0L;
    @Unique
    private int enhancedTooltips$lastTiltSlot = -1;
    @Unique
    private float enhancedTooltips$tiltDirection = 0.0f;
    @Unique
    private static final int enhancedTooltips$SPACING = 4;
    @Shadow
    private ItemStack lastToolHighlight;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    private int toolHighlightTimer;

    @Shadow
    public abstract Font getFont();

    @Inject(method={"renderSelectedItemName(Lnet/minecraft/client/gui/GuiGraphics;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawStringWithBackdrop(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIII)I")}, cancellable=true)
    private void enhancedTooltips$renderHeldItemTooltipBackground(GuiGraphics context, int YShift, CallbackInfo ci) {
        float alpha;
        int currentSlot;
        List tooltip;
        EnhancedTooltipsConfig config = EnhancedTooltipsConfig.load();
        if (config.heldItemTooltip.mode == EnhancedTooltipsConfig.HeldItemTooltipMode.OFF) {
            return;
        }
        if (config.heldItemTooltip.mode == EnhancedTooltipsConfig.HeldItemTooltipMode.ON) {
            tooltip = Screen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)this.lastToolHighlight);
            TooltipItemStackCache.saveItemStack(ItemStack.EMPTY);
            if (tooltip.isEmpty()) {
                return;
            }
        } else {
            tooltip = Lists.newArrayList((Object[])new Component[]{TooltipHelper.getDisplayName(this.lastToolHighlight)});
        }
        Font textRenderer = this.getFont();
        int n = currentSlot = this.minecraft.player != null ? ((PlayerInventoryAccessor)this.minecraft.player.getInventory()).getSelectedSlot() : this.enhancedTooltips$lastTiltSlot;
        if (currentSlot != this.enhancedTooltips$lastTiltSlot) {
            int delta = currentSlot - this.enhancedTooltips$lastTiltSlot;
            if (this.enhancedTooltips$lastTiltSlot == 8 && currentSlot == 0) {
                delta = 1;
            } else if (this.enhancedTooltips$lastTiltSlot == 0 && currentSlot == 8) {
                delta = -1;
            }
            this.enhancedTooltips$tiltDirection = Math.signum(delta);
            this.enhancedTooltips$tiltStartTime = System.currentTimeMillis();
            this.enhancedTooltips$lastTiltSlot = currentSlot;
        }
        Tuple<Component, Integer> badgeText = BadgesUtils.getBadgeText(this.lastToolHighlight);
        if (config.general.itemBadges && !((Component)badgeText.getA()).toFlatList().isEmpty()) {
            MutableComponent name = ((Component)tooltip.getFirst()).copy().append((Component)Component.literal((String)" (").withColor(-4539718)).append((Component)((Component)badgeText.getA()).copy().withColor(((Integer)badgeText.getB()).intValue())).append((Component)Component.literal((String)")").withColor(-4539718));
            tooltip.set(0, name);
        }
        if (config.general.rarityTooltip) {
            tooltip.add(1, TooltipHelper.getRarityName(this.lastToolHighlight));
        }
        if (config.heldItemTooltip.mode == EnhancedTooltipsConfig.HeldItemTooltipMode.ON) {
            this.enhancedTooltips$addFoodTooltip(tooltip::add);
        }
        if (this.minecraft.options.advancedItemTooltips) {
            tooltip.remove(Component.translatable((String)"item.durability", (Object[])new Object[]{this.lastToolHighlight.getMaxDamage() - this.lastToolHighlight.getDamageValue(), this.lastToolHighlight.getMaxDamage()}));
            tooltip.remove(Component.literal((String)BuiltInRegistries.ITEM.getKey((Object)this.lastToolHighlight.getItem()).toString()).withStyle(ChatFormatting.DARK_GRAY));
            tooltip.remove(Component.translatable((String)"item.components", (Object[])new Object[]{this.lastToolHighlight.getComponents().size()}).withStyle(ChatFormatting.DARK_GRAY));
        }
        if ((!config.durability.durabilityTooltip.equals((Object)EnhancedTooltipsConfig.DurabilityTooltipMode.OFF) || config.durability.durabilityBar) && this.lastToolHighlight.isDamageableItem()) {
            tooltip.add(Component.translatable((String)"enhancedtooltips.tooltip.durability").append(this.enhancedTooltips$getDurabilityText()));
        }
        float scale = config.heldItemTooltip.scaleFactor;
        float maxWidth = (float)context.guiWidth() / (2.0f * scale);
        for (Component component : new ArrayList(tooltip)) {
            if (!((float)textRenderer.width((FormattedText)component) > maxWidth)) continue;
            ArrayList wrapped = new ArrayList();
            textRenderer.split((FormattedText)component, (int)maxWidth).forEach(line -> wrapped.add(EnhancedTooltipsTextVisitor.get(line)));
            tooltip.addAll(tooltip.indexOf(component), wrapped);
            tooltip.remove(component);
        }
        AtomicInteger cutOff = new AtomicInteger();
        tooltip.removeIf(text -> {
            if (tooltip.indexOf(text) > config.heldItemTooltip.maxLines) {
                cutOff.incrementAndGet();
                return true;
            }
            return textRenderer.width((FormattedText)text) == 0;
        });
        if (cutOff.get() > 0) {
            tooltip.add(Component.literal((String)("(+" + cutOff.get() + " more...)")).withColor(-4539718).withStyle(s -> s.withItalic(Boolean.valueOf(true))));
        }
        int width = tooltip.stream().mapToInt(arg_0 -> ((Font)textRenderer).width(arg_0)).max().orElse(0);
        float x = ((float)context.guiWidth() - (float)width * scale) / 2.0f;
        float y = context.guiHeight() - 59;
        Objects.requireNonNull(textRenderer);
        y -= (9.0f + 2.0f) * (float)tooltip.size() * scale - 12.0f + 2.0f;
        if (this.minecraft.player.getArmorValue() > 0 && this.minecraft.gameMode != null && this.minecraft.gameMode.canHurtPlayer()) {
            y -= 8.0f;
        }
        if ((alpha = (float)(this.toolHighlightTimer * 256) / 10.0f) > 255.0f) {
            alpha = 255.0f;
        }
        MatricesUtil matrices = new MatricesUtil(context.pose());
        matrices.pushMatrix();
        this.enhancedTooltips$drawTextWithBackground(textRenderer, tooltip, (int)x, (int)y, width, context, (int)alpha, scale);
        matrices.popMatrix();
        ci.cancel();
    }

    @Unique
    public void enhancedTooltips$addFoodTooltip(Consumer<Component> list) {
        FoodProperties foodComponent = this.enhancedTooltips$getFoodComponent();
        if (foodComponent == null) {
            return;
        }
        int hunger = this.enhancedTooltips$getHunger();
        int saturation = this.enhancedTooltips$getSaturation();
        MutableComponent hungerText = Component.translatable((String)"enhancedtooltips.tooltip.hunger").append(" " + hunger + " ").append((Component)Component.translatable((String)"effect.minecraft.hunger"));
        MutableComponent saturationText = Component.translatable((String)"enhancedtooltips.tooltip.saturation", (Object[])new Object[]{saturation}).withColor(-16711681);
        if (EnhancedTooltipsConfig.load().foodAndDrinks.hungerTooltip) {
            list.accept((Component)hungerText);
        }
        if (EnhancedTooltipsConfig.load().foodAndDrinks.saturationTooltip) {
            list.accept((Component)saturationText);
        }
        for (FoodProperties.PossibleEffect entry : foodComponent.effects()) {
            MobEffectInstance statusEffect = entry.effect();
            int c = ((MobEffect)statusEffect.getEffect().value()).getColor();
            MutableComponent effectText = Component.literal((String)"\u25c8 ").append((Component)Component.translatable((String)statusEffect.getDescriptionId())).append(" (").append(MobEffectUtil.formatDuration((MobEffectInstance)statusEffect, (float)1.0f, (float)20.0f)).append(")").withColor(c);
            float probability = entry.probability();
            if (!(probability >= 1.0f)) {
                effectText = effectText.append(" [").append(Math.round(probability * 100.0f) + "%").append("]");
            }
            list.accept((Component)effectText);
        }
    }

    @Unique
    public FoodProperties enhancedTooltips$getFoodComponent() {
        FoodProperties foodComponent = (FoodProperties)this.lastToolHighlight.getItem().components().get(DataComponents.FOOD);
        return foodComponent;
    }

    @Unique
    public int enhancedTooltips$getHunger() {
        FoodProperties foodComponent = this.enhancedTooltips$getFoodComponent();
        int hunger = 0;
        if (foodComponent != null) {
            hunger = foodComponent.nutrition();
        }
        return hunger;
    }

    @Unique
    public int enhancedTooltips$getSaturation() {
        FoodProperties foodComponent = this.enhancedTooltips$getFoodComponent();
        int saturation = 0;
        int hunger = this.enhancedTooltips$getHunger();
        if (foodComponent != null) {
            saturation = (int)((double)foodComponent.saturation() / ((double)hunger * 2.0) * 100.0);
        }
        return saturation;
    }

    @Unique
    private Component enhancedTooltips$getDurabilityText() {
        int remaining = this.lastToolHighlight.getMaxDamage() - this.lastToolHighlight.getDamageValue();
        if (remaining <= 0) {
            return Component.empty();
        }
        return switch (EnhancedTooltipsConfig.load().durability.durabilityTooltip) {
            case EnhancedTooltipsConfig.DurabilityTooltipMode.VALUE -> Component.literal((String)" ").append((Component)Component.literal((String)String.valueOf(remaining)).setStyle(Style.EMPTY.withColor(this.lastToolHighlight.getBarColor()))).append((Component)Component.literal((String)" / ").setStyle(Style.EMPTY.withColor(-4539718))).append((Component)Component.literal((String)String.valueOf(this.lastToolHighlight.getMaxDamage())).setStyle(Style.EMPTY.withColor(-16711936)));
            case EnhancedTooltipsConfig.DurabilityTooltipMode.PERCENTAGE -> {
                int percent = remaining * 100 / this.lastToolHighlight.getMaxDamage();
                yield Component.literal((String)(" " + percent + "%")).setStyle(Style.EMPTY.withColor(this.lastToolHighlight.getBarColor()));
            }
            default -> {
                int i;
                int filledCount = remaining * 10 / this.lastToolHighlight.getMaxDamage();
                MutableComponent durabilityBar = Component.literal((String)" ");
                for (i = 0; i < filledCount; ++i) {
                    durabilityBar.append((Component)Component.literal((String)"=").setStyle(Style.EMPTY.withColor(this.lastToolHighlight.getBarColor())));
                }
                for (i = filledCount; i < 10; ++i) {
                    durabilityBar.append((Component)Component.literal((String)"=").setStyle(Style.EMPTY.withColor(-4539718)));
                }
                yield durabilityBar;
            }
        };
    }

    @Unique
    private void enhancedTooltips$drawTextWithBackground(Font textRenderer, List<Component> lines, int x, int y, int width, GuiGraphics context, int alpha, float scale) {
        int bgAlpha = 128 * alpha / 255 << 24;
        float tilt = this.enhancedTooltips$getTilt();
        MatricesUtil matrices = new MatricesUtil(context.pose());
        matrices.pushMatrix();
        float f = (float)x + (float)width * scale / 2.0f;
        float f2 = y;
        Objects.requireNonNull(textRenderer);
        matrices.trans(f, f2 + (float)(9 * lines.size()) * scale / 2.0f, 0.0f);
        matrices.scal(scale, scale, 0.0f);
        context.pose().mulPose(Axis.ZP.rotationDegrees(tilt));
        float f3 = -((float)x / scale + (float)width / 2.0f);
        float f4 = (float)y / scale;
        Objects.requireNonNull(textRenderer);
        matrices.trans(f3, -(f4 + (float)(9 * lines.size()) / 2.0f), 0.0f);
        if (EnhancedTooltipsConfig.load().heldItemTooltip.showBackground) {
            int n = (int)((float)x / scale - 4.0f + 1.0f);
            int n2 = (int)((float)y / scale - 2.0f);
            int n3 = (int)((float)x / scale + (float)width + 4.0f - 1.0f);
            float f5 = (float)y / scale;
            Objects.requireNonNull(textRenderer);
            context.fill(n, n2, n3, (int)(f5 + (9.0f + 2.0f) * (float)lines.size() - 2.0f), bgAlpha);
        }
        int textY = (int)((float)y / scale);
        for (Component line : lines) {
            int color = (line.getStyle().getColor() != null ? line.getStyle().getColor().getValue() : 0xFFFFFF) | alpha << 24;
            context.drawString(textRenderer, (Component)line.copy().withColor(color), (int)(((float)context.guiWidth() / scale - (float)textRenderer.width((FormattedText)line)) / 2.0f), textY, color, true);
            Objects.requireNonNull(textRenderer);
            textY += 9 + 2;
        }
        int frameAlpha = 112 * alpha / 255 << 24;
        if (EnhancedTooltipsConfig.load().heldItemTooltip.showBackground) {
            int n = (int)((float)x / scale - 4.0f);
            int n4 = (int)((float)y / scale - 2.0f);
            Objects.requireNonNull(textRenderer);
            BadgesUtils.drawFrame(context, n, n4, width + 8, (9 + 2) * lines.size() + 2, 400, frameAlpha);
        }
        matrices.popMatrix();
    }

    @Unique
    private float enhancedTooltips$getTilt() {
        float duration;
        if (!EnhancedTooltipsConfig.load().heldItemTooltip.tiltAnimation || this.enhancedTooltips$tiltDirection == 0.0f) {
            return 0.0f;
        }
        long elapsed = System.currentTimeMillis() - this.enhancedTooltips$tiltStartTime;
        if ((float)elapsed > (duration = (float)EnhancedTooltipsConfig.load().heldItemTooltip.tiltDuration)) {
            return 0.0f;
        }
        float eased = (float)Math.pow(1.0f - (float)elapsed / duration, EnhancedTooltipsConfig.load().heldItemTooltip.tiltEasing);
        return this.enhancedTooltips$tiltDirection * EnhancedTooltipsConfig.load().heldItemTooltip.tiltMagnitude * eased;
    }
}

