/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import com.mojang.blaze3d.platform.Lighting;
import dev.ultimatchamp.enhancedtooltips.component.TooltipBorderColorComponent;
import dev.ultimatchamp.enhancedtooltips.config.EnhancedTooltipsConfig;
import dev.ultimatchamp.enhancedtooltips.mixin.accessors.BucketItemEntityTypeAccessor;
import dev.ultimatchamp.enhancedtooltips.mixin.accessors.SpawnEggItemEntityTypeAccessor;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ModelViewerTooltipComponent
extends TooltipBorderColorComponent {
    private static float currentRotation = 0.0f;
    private static final int SPACING = 20;
    private static final int MAX_TOOLTIP_SIZE = 80;
    private static final float REFERENCE_SIZE = 3.5f;
    private final ItemStack stack;
    private final EnhancedTooltipsConfig config;
    private final float ROTATION_INCREMENT;

    public ModelViewerTooltipComponent(ItemStack stack) {
        super(stack);
        this.stack = stack;
        this.config = EnhancedTooltipsConfig.load();
        this.ROTATION_INCREMENT = this.config.mobs.rotationSpeed;
    }

    public static EquipmentSlot getEquipmentSlot(ItemStack itemStack) {
        Equippable equippable = (Equippable)itemStack.get(DataComponents.EQUIPPABLE);
        return equippable != null ? equippable.slot() : EquipmentSlot.MAINHAND;
    }

    @Override
    public void render(GuiGraphics context, int x, int y, int width, int height, int z, int page) throws Exception {
        super.render(context, x, y, width, height, z, page);
        if (page != 0) {
            return;
        }
        currentRotation = (currentRotation + this.ROTATION_INCREMENT) % 360.0f;
        if (ModelViewerTooltipComponent.getEquipmentSlot(this.stack).getType() == EquipmentSlot.Type.HUMANOID_ARMOR || this.stack.is(Items.ELYTRA)) {
            if (!this.config.mobs.armorTooltip) {
                return;
            }
            this.renderArmorStand(context, x, y, z);
        } else if (this.stack.getItem() instanceof SmithingTemplateItem) {
            if (!this.config.mobs.armorTooltip) {
                return;
            }
            this.renderArmorTrim(context, x, y, z);
        } else if (this.stack.getItem().toString().contains("horse_armor")) {
            if (!this.config.mobs.horseArmorTooltip) {
                return;
            }
            this.renderHorseArmor(context, x, y, z);
        } else if (this.stack.is(Items.WOLF_ARMOR)) {
            if (!this.config.mobs.wolfArmorTooltip) {
                return;
            }
            this.renderWolfArmor(context, x, y, z);
        } else {
            Item item = this.stack.getItem();
            if (item instanceof MobBucketItem) {
                MobBucketItem bucketItem = (MobBucketItem)item;
                if (!this.config.mobs.bucketTooltip) {
                    return;
                }
                this.renderBucketEntity(context, x, y, z, bucketItem);
            } else {
                item = this.stack.getItem();
                if (item instanceof SpawnEggItem) {
                    SpawnEggItem spawnEggItem = (SpawnEggItem)item;
                    if (!this.config.mobs.spawnEggTooltip) {
                        return;
                    }
                    this.renderSpawnEggEntity(context, x, y, z, spawnEggItem);
                }
            }
        }
    }

    private void renderArmorStand(GuiGraphics context, int x, int y, int z) throws Exception {
        ArmorStand armorStand = new ArmorStand(EntityType.ARMOR_STAND, (Level)Minecraft.getInstance().level);
        armorStand.setItemSlot(ModelViewerTooltipComponent.getEquipmentSlot(this.stack), this.stack);
        super.render(context, x - 65, y, 40, 70, z, -1);
        ModelViewerTooltipComponent.drawEntity(context, x - 15 - 20 - 10, y + 65, 30.0f, currentRotation, (LivingEntity)armorStand);
    }

    private void renderArmorTrim(GuiGraphics context, int x, int y, int z) throws Exception {
        ArmorStand armorStand = new ArmorStand(EntityType.ARMOR_STAND, (Level)Minecraft.getInstance().level);
        List<ItemStack> armorPieces = List.of(Items.NETHERITE_HELMET.getDefaultInstance(), Items.NETHERITE_CHESTPLATE.getDefaultInstance(), Items.NETHERITE_LEGGINGS.getDefaultInstance(), Items.NETHERITE_BOOTS.getDefaultInstance());
        for (ItemStack armor : armorPieces) {
            ResourceLocation id = ResourceLocation.parse((String)StringUtils.substringBefore((String)this.stack.getItem().toString(), (String)"_"));
            ClientLevel world = Minecraft.getInstance().level;
            if (world == null) {
                return;
            }
            RegistryAccess registryManager = world.registryAccess();
            Optional mat = registryManager.lookup(Registries.TRIM_MATERIAL);
            Optional pat = registryManager.lookup(Registries.TRIM_PATTERN);
            if (mat.isEmpty() || pat.isEmpty()) {
                return;
            }
            Holder.Reference material = (Holder.Reference)((Registry)mat.get()).get(ResourceLocation.withDefaultNamespace((String)"diamond")).orElseThrow();
            Holder.Reference pattern = (Holder.Reference)((Registry)pat.get()).get(id).orElseThrow();
            armor.set(DataComponents.TRIM, (Object)new ArmorTrim((Holder)material, (Holder)pattern));
            armorStand.setItemSlot(ModelViewerTooltipComponent.getEquipmentSlot(armor), armor);
        }
        super.render(context, x - 65, y, 40, 70, z, -1);
        ModelViewerTooltipComponent.drawEntity(context, x - 15 - 20 - 10, y + 65, 30.0f, currentRotation, (LivingEntity)armorStand);
    }

    private void renderHorseArmor(GuiGraphics context, int x, int y, int z) throws Exception {
        EntityType entityType = EntityType.HORSE;
        Horse horse = (Horse)entityType.create((Level)Minecraft.getInstance().level, EntitySpawnReason.SPAWN_ITEM_USE);
        if (horse == null) {
            return;
        }
        horse.setItemSlot(EquipmentSlot.BODY, this.stack);
        float entityWidth = horse.getBbWidth();
        float entityHeight = horse.getBbHeight();
        float entityScale = this.calculateScale(entityWidth, entityHeight);
        int scaledWidth = (int)(entityWidth * entityScale);
        int scaledHeight = (int)(entityHeight * entityScale);
        int entityOffset = scaledWidth + 20 - 10;
        super.render(context, x - entityOffset - 70, y, scaledWidth + 60, scaledHeight + 20, z, -1);
        ModelViewerTooltipComponent.drawEntity(context, x - scaledWidth / 2 - 20 - 30, y + scaledHeight + 20, entityScale, currentRotation, (LivingEntity)horse);
    }

    private void renderWolfArmor(GuiGraphics context, int x, int y, int z) throws Exception {
        EntityType entityType = EntityType.WOLF;
        Wolf wolf = (Wolf)entityType.create((Level)Minecraft.getInstance().level, EntitySpawnReason.SPAWN_ITEM_USE);
        if (wolf == null) {
            return;
        }
        wolf.setItemSlot(EquipmentSlot.BODY, this.stack);
        float entityWidth = wolf.getBbWidth();
        float entityHeight = wolf.getBbHeight();
        float entityScale = this.calculateScale(entityWidth, entityHeight);
        int scaledWidth = (int)(entityWidth * entityScale);
        int scaledHeight = (int)(entityHeight * entityScale);
        int entityOffset = scaledWidth + 20 - 10;
        super.render(context, x - entityOffset - 70, y, scaledWidth + 50, scaledHeight + 10, z, -1);
        ModelViewerTooltipComponent.drawEntity(context, x - scaledWidth / 2 - 20 - 35, y + scaledHeight + 10, entityScale, currentRotation, (LivingEntity)wolf);
    }

    private void renderBucketEntity(GuiGraphics context, int x, int y, int z, MobBucketItem bucketItem) throws Exception {
        EntityType<? extends Mob> entityType = ((BucketItemEntityTypeAccessor)bucketItem).get();
        Mob entity = (Mob)entityType.create((Level)Minecraft.getInstance().level, EntitySpawnReason.BUCKET);
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            CustomData nbtComponent = (CustomData)this.stack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
            bucketable.loadFromBucketTag(nbtComponent.copyTag());
            if (entity instanceof AbstractSchoolingFish) {
                return;
            }
            if (bucketable instanceof Pufferfish) {
                Pufferfish pufferfishEntity = (Pufferfish)bucketable;
                pufferfishEntity.setPuffState(2);
            }
            float entityWidth = entity.getBbWidth();
            float entityHeight = entity.getBbHeight();
            float entityScale = this.calculateScale(entityWidth, entityHeight);
            int scaledWidth = (int)(entityWidth * entityScale);
            int scaledHeight = (int)(entityHeight * entityScale);
            int entityOffset = scaledWidth + 20 - 10;
            super.render(context, x - entityOffset - 70, y, scaledWidth + 50, scaledHeight + 20, z, -1);
            ModelViewerTooltipComponent.drawEntity(context, x - scaledWidth / 2 - 20 - 35, y + scaledHeight + 20, entityScale, currentRotation, (LivingEntity)bucketable);
        }
    }

    private void renderSpawnEggEntity(GuiGraphics context, int x, int y, int z, SpawnEggItem spawnEggItem) throws Exception {
        EntityType<? extends Mob> entityType = ((SpawnEggItemEntityTypeAccessor)spawnEggItem).get();
        Mob entity = (Mob)entityType.create((Level)Minecraft.getInstance().level, EntitySpawnReason.BUCKET);
        if (entityType == EntityType.VILLAGER || entityType == EntityType.ZOMBIE_VILLAGER) {
            ClientLevel world = Minecraft.getInstance().level;
            if (entity != null && world != null) {
                ((VillagerDataHolder)entity).setVillagerData(Villager.createDefaultVillagerData().withLevel(1).withProfession((HolderGetter.Provider)world.registryAccess(), VillagerProfession.FARMER).withType((HolderGetter.Provider)world.registryAccess(), VillagerType.PLAINS));
            }
        }
        if (entity instanceof AbstractSchoolingFish) {
            return;
        }
        if (entity instanceof Pufferfish) {
            Pufferfish pufferfishEntity = (Pufferfish)entity;
            pufferfishEntity.setPuffState(2);
        }
        if (entity instanceof SnowGolem) {
            SnowGolem snowGolemEntity = (SnowGolem)entity;
            snowGolemEntity.setPumpkin(false);
        }
        if (entity instanceof LivingEntity) {
            Mob livingEntity = entity;
            float entityWidth = entity.getBbWidth();
            float entityHeight = entity.getBbHeight();
            float entityScale = this.calculateScale(entityWidth, entityHeight);
            int scaledWidth = (int)(entityWidth * entityScale);
            int scaledHeight = (int)(entityHeight * entityScale);
            int entityOffset = scaledWidth + 20 - 10;
            super.render(context, x - entityOffset - 70, y, scaledWidth + 50, scaledHeight + 20, z, -1);
            ModelViewerTooltipComponent.drawEntity(context, x - scaledWidth / 2 - 20 - 35, y + scaledHeight + 20, entityScale, currentRotation, (LivingEntity)livingEntity);
        }
    }

    private float calculateScale(float width, float height) {
        float longerDimension = Math.max(width, height);
        float scale = 22.857143f * longerDimension;
        if (scale > 80.0f) {
            return 80.0f / longerDimension;
        }
        if (scale < 30.0f && longerDimension < 1.0f) {
            return 30.0f / longerDimension;
        }
        return scale / longerDimension;
    }

    public static void drawEntity(GuiGraphics context, int x, int y, float scale, float rotationYaw, LivingEntity entity) {
        entity.yBodyRot = rotationYaw;
        entity.setYRot(rotationYaw);
        entity.yHeadRot = rotationYaw;
        Quaternionf modelRotation = new Quaternionf().rotateY((float)Math.toRadians(rotationYaw)).rotateX((float)Math.toRadians(180.0));
        ModelViewerTooltipComponent.drawEntity(context, x, y, scale, modelRotation, (Entity)entity);
    }

    public static void drawEntity(GuiGraphics context, int x, int y, float scale, Quaternionf rotation, Entity entity) {
        Lighting.setupForFlatItems();
        context.pose().pushPose();
        context.pose().translate((float)x, (float)y, 450.0f);
        context.pose().mulPose((Matrix4fc)new Matrix4f().scaling(scale, scale, scale));
        context.pose().mulPose((Quaternionfc)rotation);
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        dispatcher.setRenderShadow(false);
        dispatcher.render(entity, 0.0, 0.0, 0.0, 0.0f, context.pose(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), 0xF000F0);
        dispatcher.setRenderShadow(true);
        context.pose().popPose();
        Lighting.setupFor3DItems();
    }
}

