/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.util;

import dev.ultimatchamp.enhancedtooltips.util.ItemGroupsUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class BadgesUtils {
    private static Map<String, String> mods = new HashMap<String, String>();

    @NotNull
    public static Tuple<Component, Integer> getBadgeText(ItemStack stack) {
        MutableComponent text = Component.empty();
        int fillColor = 0;
        for (Map.Entry<Collection<Item>, Tuple<Component, Integer>> entry : ItemGroupsUtils.getItemGroups().entrySet()) {
            if (!entry.getKey().contains(stack.getItem())) continue;
            text = (Component)entry.getValue().getA();
            fillColor = (Integer)entry.getValue().getB();
            break;
        }
        if (text.toFlatList().isEmpty()) {
            String namespace = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace();
            text = Component.literal((String)BadgesUtils.getMods().getOrDefault(namespace, ""));
            fillColor = BadgesUtils.getColorFromModName(namespace);
        }
        return new Tuple((Object)text, (Object)fillColor);
    }

    public static Map<String, String> getMods() {
        if (!mods.isEmpty()) {
            return mods;
        }
        for (ModContainer modContainer : ModList.get().getSortedMods()) {
            if (modContainer.getModId().equals("minecraft")) continue;
            mods.put(modContainer.getNamespace(), modContainer.getModInfo().getDisplayName());
        }
        return mods;
    }

    public static int darkenColor(int color, float factor) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = Math.max(0, (int)((float)red * factor));
        green = Math.max(0, (int)((float)green * factor));
        blue = Math.max(0, (int)((float)blue * factor));
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int getColorFromModName(String modName) {
        int hash = modName.hashCode();
        int r = hash >> 16 & 0xFF;
        int g = hash >> 8 & 0xFF;
        int b = hash & 0xFF;
        int a = 255;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void drawFrame(GuiGraphics context, int x, int y, int width, int height, int z, int color) {
        BadgesUtils.renderVerticalLine(context, x, y, height - 2, z, color);
        BadgesUtils.renderVerticalLine(context, x + width - 1, y, height - 2, z, color);
        BadgesUtils.renderHorizontalLine(context, x + 1, y - 1, width - 2, z, color);
        BadgesUtils.renderHorizontalLine(context, x + 1, y - 1 + height - 1, width - 2, z, color);
    }

    private static void renderVerticalLine(GuiGraphics context, int x, int y, int height, int z, int color) {
        context.fill(x, y, x + 1, y + height, color);
    }

    private static void renderHorizontalLine(GuiGraphics context, int x, int y, int width, int z, int color) {
        context.fill(x, y, x + width, y + 1, color);
    }
}

