/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.ItemStack;

public class PaintingTooltipComponent
implements ClientTooltipComponent {
    private final PaintingVariant variant;
    private final int width;
    private final int height;

    public PaintingTooltipComponent(ItemStack stack) {
        Holder variant = (Holder)stack.getOrDefault(DataComponents.PAINTING_VARIANT, null);
        if (variant != null) {
            this.variant = (PaintingVariant)variant.value();
            this.width = ((PaintingVariant)variant.value()).width() * 25;
            this.height = ((PaintingVariant)variant.value()).height() * 25;
        } else {
            this.variant = null;
            this.width = 0;
            this.height = 0;
        }
    }

    public int getHeight(Font textRenderer) {
        return this.height;
    }

    public int getWidth(Font textRenderer) {
        return this.width;
    }

    public void renderImage(Font textRenderer, int x, int y, int width, int height, GuiGraphics context) {
        if (this.variant == null) {
            return;
        }
        PaintingTextureManager paintingManager = Minecraft.getInstance().getPaintingTextures();
        TextureAtlasSprite sprite = paintingManager.get(this.variant);
        context.blitSprite(RenderType::guiTextured, sprite, x, y, this.width, this.height);
    }
}

