/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import dev.ultimatchamp.enhancedtooltips.config.EnhancedTooltipsConfig;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;

public class TooltipBackgroundComponent
implements ClientTooltipComponent {
    protected static final int INNER_PADDING = 4;

    public void render(GuiGraphics context, int x, int y, int width, int height, int z, int page) throws Exception {
        int i = x - 4;
        int j = y - 4;
        int k = width + 8;
        int l = height + 8;
        int bgColor = EnhancedTooltipsConfig.load().background.backgroundColor.getRGB();
        this.renderHorizontalLine(context, i, j - 1, k, z, bgColor);
        this.renderHorizontalLine(context, i, j + l, k, z, bgColor);
        this.renderRectangle(context, i, j, k, l, z, bgColor);
        this.renderVerticalLine(context, i - 1, j, l, z, bgColor, bgColor);
        this.renderVerticalLine(context, i + k, j, l, z, bgColor, bgColor);
        this.renderBorder(context, i, j + 1, k, l, z, page);
    }

    protected void renderBorder(GuiGraphics context, int x, int y, int width, int height, int z, int page) {
        int startColor = EnhancedTooltipsConfig.BorderColor.COMMON.getColor().getRGB();
        int endColor = EnhancedTooltipsConfig.BorderColor.END_COLOR.getColor().getRGB();
        if (EnhancedTooltipsConfig.load().border.borderColor == EnhancedTooltipsConfig.BorderColorMode.CUSTOM) {
            startColor = EnhancedTooltipsConfig.load().border.customBorderColors.common.getRGB();
            endColor = EnhancedTooltipsConfig.load().border.customBorderColors.endColor.getRGB();
        }
        this.renderVerticalLine(context, x, y, height - 2, z, startColor, endColor);
        this.renderVerticalLine(context, x + width - 1, y, height - 2, z, startColor, endColor);
        this.renderHorizontalLine(context, x, y - 1, width, z, startColor);
        this.renderHorizontalLine(context, x, y - 1 + height - 1, width, z, endColor);
    }

    protected void renderVerticalLine(GuiGraphics context, int x, int y, int height, int z, int startColor, int endColor) {
        context.fillGradient(x, y, x + 1, y + height, startColor, endColor);
    }

    protected void renderHorizontalLine(GuiGraphics context, int x, int y, int width, int z, int color) {
        context.fill(x, y, x + width, y + 1, color);
    }

    protected void renderRectangle(GuiGraphics context, int x, int y, int width, int height, int z, int bgColor) {
        context.fill(x, y, x + width, y + height, bgColor);
    }

    public int getHeight(Font textRenderer) {
        return 0;
    }

    public int getWidth(Font textRenderer) {
        return 0;
    }
}

