/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class PaintingTooltipComponent
implements ClientTooltipComponent {
    private final PaintingVariant variant;
    private final int width;
    private final int height;

    public PaintingTooltipComponent(ItemStack stack) {
        CustomData nbtComponent = (CustomData)stack.getOrDefault(DataComponents.ENTITY_DATA, null);
        Painting painting = (Painting)EntityType.PAINTING.create((Level)Minecraft.getInstance().level, EntitySpawnReason.SPAWN_ITEM_USE);
        if (nbtComponent != null && painting != null) {
            painting.load(nbtComponent.copyTag());
            this.variant = (PaintingVariant)painting.getVariant().value();
            this.width = this.variant.width() * 25;
            this.height = this.variant.height() * 25;
        } else {
            this.variant = null;
            this.width = 0;
            this.height = 0;
        }
    }

    public int getHeight(Font textRenderer) {
        return this.height;
    }

    public int getWidth(Font textRenderer) {
        return this.width;
    }

    public void renderImage(Font textRenderer, int x, int y, int width, int height, GuiGraphics context) {
        if (this.variant == null) {
            return;
        }
        PaintingTextureManager paintingManager = Minecraft.getInstance().getPaintingTextures();
        TextureAtlasSprite sprite = paintingManager.get(this.variant);
        context.blitSprite(RenderType::guiTextured, sprite, x, y, this.width, this.height);
    }
}

