/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public record BannerPatternTooltipComponent(ItemStack stack) implements ClientTooltipComponent
{
    private TagKey<BannerPattern> getBannerPatternComponent() {
        return ((BannerPatternItem)this.stack.getItem()).getBannerPattern();
    }

    public int getHeight(Font textRenderer) {
        return 45;
    }

    public int getWidth(Font textRenderer) {
        return 20;
    }

    public void renderImage(Font textRenderer, int x, int y, int width, int height, GuiGraphics context) {
        TagKey<BannerPattern> c = this.getBannerPatternComponent();
        ClientLevel world = Minecraft.getInstance().level;
        if (c == null || world == null) {
            return;
        }
        world.registryAccess().lookup(Registries.BANNER_PATTERN).flatMap(registry -> registry.getRandomElementOf(c, RandomSource.create())).ifPresent(entry -> {
            BannerPatternLayers patterns = new BannerPatternLayers(List.of(new BannerPatternLayers.Layer(entry, DyeColor.WHITE)));
            ModelPart modelPart = Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.BANNER).getChild("flag");
            if (modelPart == null) {
                return;
            }
            Lighting.setupForFlatItems();
            context.pose().pushPose();
            context.pose().translate((float)x, (float)(y + 56 - 10), 0.0f);
            context.pose().scale(24.0f, 24.0f, 1.0f);
            context.pose().translate(0.5, -0.5, 0.5);
            float f = 0.6666667f;
            context.pose().scale(f, f, -f);
            modelPart.xRot = 0.0f;
            modelPart.y = -32.0f;
            BannerRenderer.renderPatterns((PoseStack)context.pose(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY, (ModelPart)modelPart, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)DyeColor.GRAY, (BannerPatternLayers)patterns);
            context.pose().popPose();
            context.flush();
            Lighting.setupFor3DItems();
        });
    }
}

