/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import dev.ultimatchamp.enhancedtooltips.config.EnhancedTooltipsConfig;
import dev.ultimatchamp.enhancedtooltips.util.BadgesUtils;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;

public class DurabilityTooltipComponent
implements class_5684 {
    private static final int SPACING = 4;
    private static final int WIDTH = 80;
    private final class_1799 stack;
    private final EnhancedTooltipsConfig config;

    public DurabilityTooltipComponent(class_1799 stack) {
        this.stack = stack;
        this.config = EnhancedTooltipsConfig.load();
    }

    public boolean isDurabilityDisabled() {
        return !this.stack.method_7963() || this.config.durability.durabilityTooltip.equals((Object)EnhancedTooltipsConfig.DurabilityTooltipMode.OFF) && !this.config.durability.durabilityBar;
    }

    private class_2561 getDurabilityText() {
        int damaged = this.stack.method_7936() - this.stack.method_7919();
        return switch (this.config.durability.durabilityTooltip) {
            case EnhancedTooltipsConfig.DurabilityTooltipMode.VALUE -> {
                if (this.config.durability.durabilityBar) {
                    yield class_2561.method_43470((String)(" " + damaged + " / " + this.stack.method_7936()));
                }
                yield class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43470((String)String.valueOf(damaged)).method_10862(class_2583.field_24360.method_36139(this.stack.method_31580()))).method_10852((class_2561)class_2561.method_43470((String)" / ").method_10862(class_2583.field_24360.method_36139(-4539718))).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(this.stack.method_7936())).method_10862(class_2583.field_24360.method_36139(-16711936)));
            }
            case EnhancedTooltipsConfig.DurabilityTooltipMode.PERCENTAGE -> {
                class_5250 percentageText = class_2561.method_43470((String)(" " + damaged * 100 / this.stack.method_7936() + "%"));
                if (this.config.durability.durabilityBar) {
                    yield percentageText;
                }
                yield (class_2561)percentageText.method_36136(class_2583.field_24360.method_36139(this.stack.method_31580())).getFirst();
            }
            default -> class_2561.method_43473();
        };
    }

    public int method_32661(class_327 textRenderer) {
        if (this.isDurabilityDisabled()) {
            return 0;
        }
        return this.config.durability.durabilityBar ? 18 : 17;
    }

    public int method_32664(class_327 textRenderer) {
        if (this.isDurabilityDisabled()) {
            return 0;
        }
        int durabilityTextWidth = textRenderer.method_27525((class_5348)class_2561.method_43471((String)"enhancedtooltips.tooltip.durability"));
        if (this.config.durability.durabilityBar) {
            return durabilityTextWidth + 4 + 80 + 1;
        }
        class_2561 durability = this.getDurabilityText();
        return durabilityTextWidth + textRenderer.method_27525((class_5348)durability);
    }

    public void method_32666(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
        class_2561 durabilityText;
        if (this.isDurabilityDisabled()) {
            return;
        }
        y += this.config.durability.durabilityBar ? 4 : 8;
        if (this.config.durability.durabilityBar) {
            y += 2;
        }
        Objects.requireNonNull(textRenderer);
        int textHeight = 9;
        int textY = this.config.durability.durabilityBar ? y - textHeight + 8 + 2 : y;
        context.method_51439(textRenderer, (class_2561)class_2561.method_43471((String)"enhancedtooltips.tooltip.durability"), x, textY, -4539718, true);
        x += textRenderer.method_27525((class_5348)class_2561.method_43471((String)"enhancedtooltips.tooltip.durability")) + 4;
        int damaged = this.stack.method_7936() - this.stack.method_7919();
        if (this.config.durability.durabilityBar) {
            context.method_25294(x, textY - 2, x + damaged * 80 / this.stack.method_7936(), textY + textHeight, BadgesUtils.darkenColor(0xFF000000 | this.stack.method_31580(), 0.9f));
        }
        if (!(durabilityText = this.getDurabilityText()).equals((Object)class_2561.method_43473())) {
            int textX = this.config.durability.durabilityBar ? x + (80 - textRenderer.method_27525((class_5348)durabilityText)) / 2 : x - 4;
            context.method_51439(textRenderer, durabilityText, textX, textY, -1, true);
        }
        if (this.config.durability.durabilityBar) {
            BadgesUtils.drawFrame(context, x, textY - 2, 80, textHeight + 4, 400, BadgesUtils.darkenColor(0xFF000000 | this.stack.method_31580(), 0.8f));
        }
    }
}

