/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.util;

import dev.ultimatchamp.enhancedtooltips.util.ItemGroupsUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class BadgesUtils {
    private static Map<String, String> mods = new HashMap<String, String>();

    @NotNull
    public static class_3545<String, Integer> getBadgeText(class_1799 stack) {
        String text = "";
        int fillColor = 0;
        for (Map.Entry<List<class_1792>, class_3545<String, Integer>> entry : ItemGroupsUtils.getItemGroups().entrySet()) {
            if (!entry.getKey().contains(stack.method_7909())) continue;
            text = (String)entry.getValue().method_15442();
            fillColor = (Integer)entry.getValue().method_15441();
            break;
        }
        if (text.isEmpty()) {
            String namespace = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836();
            text = BadgesUtils.getMods().getOrDefault(namespace, "");
            fillColor = BadgesUtils.getColorFromModName(namespace);
        }
        return new class_3545((Object)text, (Object)fillColor);
    }

    public static Map<String, String> getMods() {
        if (!mods.isEmpty()) {
            return mods;
        }
        for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            if (modContainer.getMetadata().getId().equals("minecraft")) continue;
            mods.put(modContainer.getMetadata().getId(), modContainer.getMetadata().getName());
        }
        return mods;
    }

    public static int darkenColor(int color, float factor) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = Math.max(0, (int)((float)red * factor));
        green = Math.max(0, (int)((float)green * factor));
        blue = Math.max(0, (int)((float)blue * factor));
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int getColorFromModName(String modName) {
        int hash = modName.hashCode();
        int r = hash >> 16 & 0xFF;
        int g = hash >> 8 & 0xFF;
        int b = hash & 0xFF;
        int a = 255;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void drawFrame(class_332 context, int x, int y, int width, int height, int z, int color) {
        BadgesUtils.renderVerticalLine(context, x, y, height - 2, z, color);
        BadgesUtils.renderVerticalLine(context, x + width - 1, y, height - 2, z, color);
        BadgesUtils.renderHorizontalLine(context, x + 1, y - 1, width - 2, z, color);
        BadgesUtils.renderHorizontalLine(context, x + 1, y - 1 + height - 1, width - 2, z, color);
    }

    private static void renderVerticalLine(class_332 context, int x, int y, int height, int z, int color) {
        context.method_51737(x, y, x + 1, y + height, z, color);
    }

    private static void renderHorizontalLine(class_332 context, int x, int y, int width, int z, int color) {
        context.method_51737(x, y, x + width, y + 1, z, color);
    }
}

