/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import dev.ultimatchamp.enhancedtooltips.component.TooltipBorderColorComponent;
import dev.ultimatchamp.enhancedtooltips.config.EnhancedTooltipsConfig;
import dev.ultimatchamp.enhancedtooltips.mixin.accessors.BucketItemEntityTypeAccessor;
import dev.ultimatchamp.enhancedtooltips.mixin.accessors.SpawnEggItemEntityTypeAccessor;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10192;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1425;
import net.minecraft.class_1454;
import net.minecraft.class_1473;
import net.minecraft.class_1493;
import net.minecraft.class_1498;
import net.minecraft.class_1531;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3730;
import net.minecraft.class_4597;
import net.minecraft.class_5455;
import net.minecraft.class_5761;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8052;
import net.minecraft.class_8053;
import net.minecraft.class_898;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class ModelViewerTooltipComponent
extends TooltipBorderColorComponent {
    private static float currentRotation = 0.0f;
    private static final int SPACING = 20;
    private static final int MAX_TOOLTIP_SIZE = 80;
    private static final float REFERENCE_SIZE = 3.5f;
    private final class_1799 stack;
    private final EnhancedTooltipsConfig config;
    private final float ROTATION_INCREMENT;

    public ModelViewerTooltipComponent(class_1799 stack) {
        super(stack);
        this.stack = stack;
        this.config = EnhancedTooltipsConfig.load();
        this.ROTATION_INCREMENT = this.config.mobs.rotationSpeed;
    }

    public static class_1304 getEquipmentSlot(class_1799 itemStack) {
        class_10192 equippable = (class_10192)itemStack.method_57824(class_9334.field_54196);
        return equippable != null ? equippable.comp_3174() : class_1304.field_6173;
    }

    @Override
    public void render(class_332 context, int x, int y, int width, int height, int z, int page) throws Exception {
        super.render(context, x, y, width, height, z, page);
        if (page != 0) {
            return;
        }
        currentRotation = (currentRotation + this.ROTATION_INCREMENT) % 360.0f;
        if (ModelViewerTooltipComponent.getEquipmentSlot(this.stack).method_5925() == class_1304.class_1305.field_6178 || this.stack.method_31574(class_1802.field_8833)) {
            if (!this.config.mobs.armorTooltip) {
                return;
            }
            this.renderArmorStand(context, x, y, z);
        } else if (this.stack.method_7909() instanceof class_8052) {
            if (!this.config.mobs.armorTooltip) {
                return;
            }
            this.renderArmorTrim(context, x, y, z);
        } else if (this.stack.method_7909().toString().contains("horse_armor")) {
            if (!this.config.mobs.horseArmorTooltip) {
                return;
            }
            this.renderHorseArmor(context, x, y, z);
        } else if (this.stack.method_31574(class_1802.field_47831)) {
            if (!this.config.mobs.wolfArmorTooltip) {
                return;
            }
            this.renderWolfArmor(context, x, y, z);
        } else {
            class_1792 class_17922 = this.stack.method_7909();
            if (class_17922 instanceof class_1785) {
                class_1785 bucketItem = (class_1785)class_17922;
                if (!this.config.mobs.bucketTooltip) {
                    return;
                }
                this.renderBucketEntity(context, x, y, z, bucketItem);
            } else {
                class_17922 = this.stack.method_7909();
                if (class_17922 instanceof class_1826) {
                    class_1826 spawnEggItem = (class_1826)class_17922;
                    if (!this.config.mobs.spawnEggTooltip) {
                        return;
                    }
                    this.renderSpawnEggEntity(context, x, y, z, spawnEggItem);
                }
            }
        }
    }

    private void renderArmorStand(class_332 context, int x, int y, int z) throws Exception {
        class_1531 armorStand = new class_1531(class_1299.field_6131, (class_1937)class_310.method_1551().field_1687);
        armorStand.method_5673(ModelViewerTooltipComponent.getEquipmentSlot(this.stack), this.stack);
        super.render(context, x - 65, y, 40, 70, z, -1);
        ModelViewerTooltipComponent.drawEntity(context, x - 15 - 20 - 10, y + 65, 30.0f, currentRotation, (class_1309)armorStand);
    }

    private void renderArmorTrim(class_332 context, int x, int y, int z) throws Exception {
        class_1531 armorStand = new class_1531(class_1299.field_6131, (class_1937)class_310.method_1551().field_1687);
        List<class_1799> armorPieces = List.of(class_1802.field_22027.method_7854(), class_1802.field_22028.method_7854(), class_1802.field_22029.method_7854(), class_1802.field_22030.method_7854());
        for (class_1799 armor : armorPieces) {
            class_2960 id = class_2960.method_60654((String)StringUtils.substringBefore((String)this.stack.method_7909().toString(), (String)"_"));
            class_638 world = class_310.method_1551().field_1687;
            if (world == null) {
                return;
            }
            class_5455 registryManager = world.method_30349();
            Optional mat = registryManager.method_46759(class_7924.field_42083);
            Optional pat = registryManager.method_46759(class_7924.field_42082);
            if (mat.isEmpty() || pat.isEmpty()) {
                return;
            }
            class_6880.class_6883 material = (class_6880.class_6883)((class_2378)mat.get()).method_10223(class_2960.method_60656((String)"diamond")).orElseThrow();
            class_6880.class_6883 pattern = (class_6880.class_6883)((class_2378)pat.get()).method_10223(id).orElseThrow();
            armor.method_57379(class_9334.field_49607, (Object)new class_8053((class_6880)material, (class_6880)pattern));
            armorStand.method_5673(ModelViewerTooltipComponent.getEquipmentSlot(armor), armor);
        }
        super.render(context, x - 65, y, 40, 70, z, -1);
        ModelViewerTooltipComponent.drawEntity(context, x - 15 - 20 - 10, y + 65, 30.0f, currentRotation, (class_1309)armorStand);
    }

    private void renderHorseArmor(class_332 context, int x, int y, int z) throws Exception {
        class_1299 entityType = class_1299.field_6139;
        class_1498 horse = (class_1498)entityType.method_5883((class_1937)class_310.method_1551().field_1687, class_3730.field_16465);
        if (horse == null) {
            return;
        }
        horse.method_5673(class_1304.field_48824, this.stack);
        float entityWidth = horse.method_17681();
        float entityHeight = horse.method_17682();
        float entityScale = this.calculateScale(entityWidth, entityHeight);
        int scaledWidth = (int)(entityWidth * entityScale);
        int scaledHeight = (int)(entityHeight * entityScale);
        int entityOffset = scaledWidth + 20 - 10;
        super.render(context, x - entityOffset - 70, y, scaledWidth + 60, scaledHeight + 20, z, -1);
        ModelViewerTooltipComponent.drawEntity(context, x - scaledWidth / 2 - 20 - 30, y + scaledHeight + 20, entityScale, currentRotation, (class_1309)horse);
    }

    private void renderWolfArmor(class_332 context, int x, int y, int z) throws Exception {
        class_1299 entityType = class_1299.field_6055;
        class_1493 wolf = (class_1493)entityType.method_5883((class_1937)class_310.method_1551().field_1687, class_3730.field_16465);
        if (wolf == null) {
            return;
        }
        wolf.method_5673(class_1304.field_48824, this.stack);
        float entityWidth = wolf.method_17681();
        float entityHeight = wolf.method_17682();
        float entityScale = this.calculateScale(entityWidth, entityHeight);
        int scaledWidth = (int)(entityWidth * entityScale);
        int scaledHeight = (int)(entityHeight * entityScale);
        int entityOffset = scaledWidth + 20 - 10;
        super.render(context, x - entityOffset - 70, y, scaledWidth + 50, scaledHeight + 10, z, -1);
        ModelViewerTooltipComponent.drawEntity(context, x - scaledWidth / 2 - 20 - 35, y + scaledHeight + 10, entityScale, currentRotation, (class_1309)wolf);
    }

    private void renderBucketEntity(class_332 context, int x, int y, int z, class_1785 bucketItem) throws Exception {
        class_1299<? extends class_1308> entityType = ((BucketItemEntityTypeAccessor)bucketItem).get();
        class_1308 entity = (class_1308)entityType.method_5883((class_1937)class_310.method_1551().field_1687, class_3730.field_16473);
        if (entity instanceof class_5761) {
            class_5761 bucketable = (class_5761)entity;
            class_9279 nbtComponent = (class_9279)this.stack.method_57825(class_9334.field_49610, (Object)class_9279.field_49302);
            bucketable.method_35170(nbtComponent.method_57461());
            if (entity instanceof class_1425) {
                return;
            }
            if (bucketable instanceof class_1454) {
                class_1454 pufferfishEntity = (class_1454)bucketable;
                pufferfishEntity.method_6596(2);
            }
            float entityWidth = entity.method_17681();
            float entityHeight = entity.method_17682();
            float entityScale = this.calculateScale(entityWidth, entityHeight);
            int scaledWidth = (int)(entityWidth * entityScale);
            int scaledHeight = (int)(entityHeight * entityScale);
            int entityOffset = scaledWidth + 20 - 10;
            super.render(context, x - entityOffset - 70, y, scaledWidth + 50, scaledHeight + 20, z, -1);
            ModelViewerTooltipComponent.drawEntity(context, x - scaledWidth / 2 - 20 - 35, y + scaledHeight + 20, entityScale, currentRotation, (class_1309)bucketable);
        }
    }

    private void renderSpawnEggEntity(class_332 context, int x, int y, int z, class_1826 spawnEggItem) throws Exception {
        class_1299<? extends class_1308> entityType = ((SpawnEggItemEntityTypeAccessor)spawnEggItem).get();
        class_1308 entity = (class_1308)entityType.method_5883((class_1937)class_310.method_1551().field_1687, class_3730.field_16473);
        if (entityType == class_1299.field_6077 || entityType == class_1299.field_6054) {
            class_638 world = class_310.method_1551().field_1687;
            if (entity != null && world != null) {
                class_2487 villagerData = new class_2487();
                villagerData.method_10582("profession", "minecraft:none");
                villagerData.method_10582("type", "minecraft:plains");
                class_9279 nbtComponent = (class_9279)this.stack.method_57825(class_9334.field_49609, (Object)class_9279.field_49302);
                class_2487 nbt = nbtComponent.method_57461();
                nbt.method_10566("VillagerData", (class_2520)villagerData);
                entity.method_5651(nbt);
            }
        }
        if (entity instanceof class_1425) {
            return;
        }
        if (entity instanceof class_1454) {
            class_1454 pufferfishEntity = (class_1454)entity;
            pufferfishEntity.method_6596(2);
        }
        if (entity instanceof class_1473) {
            class_1473 snowGolemEntity = (class_1473)entity;
            snowGolemEntity.method_6642(false);
        }
        if (entity instanceof class_1309) {
            class_1308 livingEntity = entity;
            float entityWidth = entity.method_17681();
            float entityHeight = entity.method_17682();
            float entityScale = this.calculateScale(entityWidth, entityHeight);
            int scaledWidth = (int)(entityWidth * entityScale);
            int scaledHeight = (int)(entityHeight * entityScale);
            int entityOffset = scaledWidth + 20 - 10;
            super.render(context, x - entityOffset - 70, y, scaledWidth + 50, scaledHeight + 20, z, -1);
            ModelViewerTooltipComponent.drawEntity(context, x - scaledWidth / 2 - 20 - 35, y + scaledHeight + 20, entityScale, currentRotation, (class_1309)livingEntity);
        }
    }

    private float calculateScale(float width, float height) {
        float longerDimension = Math.max(width, height);
        float scale = 22.857143f * longerDimension;
        if (scale > 80.0f) {
            return 80.0f / longerDimension;
        }
        if (scale < 30.0f && longerDimension < 1.0f) {
            return 30.0f / longerDimension;
        }
        return scale / longerDimension;
    }

    public static void drawEntity(class_332 context, int x, int y, float scale, float rotationYaw, class_1309 entity) {
        entity.field_6283 = rotationYaw;
        entity.method_36456(rotationYaw);
        entity.field_6241 = rotationYaw;
        Quaternionf modelRotation = new Quaternionf().rotateY((float)Math.toRadians(rotationYaw)).rotateX((float)Math.toRadians(180.0));
        ModelViewerTooltipComponent.drawEntity(context, x, y, scale, modelRotation, (class_1297)entity);
    }

    public static void drawEntity(class_332 context, int x, int y, float scale, Quaternionf rotation, class_1297 entity) {
        class_308.method_24210();
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)x, (float)y, 450.0f);
        context.method_51448().method_34425(new Matrix4f().scaling(scale, scale, scale));
        context.method_51448().method_22907(rotation);
        class_898 dispatcher = class_310.method_1551().method_1561();
        dispatcher.method_3948(false);
        dispatcher.method_62424(entity, 0.0, 0.0, 0.0, 0.0f, context.method_51448(), (class_4597)class_310.method_1551().method_22940().method_23000(), 0xF000F0);
        dispatcher.method_3948(true);
        context.method_51448().method_22909();
        class_308.method_24211();
    }
}

