/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.tooltip;

import dev.ultimatchamp.enhancedtooltips.EnhancedTooltips;
import dev.ultimatchamp.enhancedtooltips.component.TooltipBackgroundComponent;
import dev.ultimatchamp.enhancedtooltips.config.EnhancedTooltipsConfig;
import dev.ultimatchamp.enhancedtooltips.mixin.accessors.DrawContextAccessor;
import dev.ultimatchamp.enhancedtooltips.mixin.accessors.OrderedTextTooltipComponentAccessor;
import dev.ultimatchamp.enhancedtooltips.util.EnhancedTooltipsTextVisitor;
import dev.ultimatchamp.enhancedtooltips.util.MatricesUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8000;
import net.minecraft.class_8002;
import org.joml.Vector2ic;

public class EnhancedTooltipsDrawer {
    private static final int EDGE_SPACING = 32;
    private static final int PAGE_SPACING = 12;
    private static long startTime = -1L;
    private static class_1799 lastStack = class_1799.field_8037;

    private static int getMaxHeight() {
        return class_310.method_1551().method_22683().method_4502() - 64;
    }

    private static int getMaxWidth() {
        return class_310.method_1551().method_22683().method_4486() / 2 - 32;
    }

    public static void drawTooltip(class_332 context, class_327 textRenderer, List<class_5684> components, int x, int y, class_8000 positioner, class_1799 currentStack) {
        if (components.isEmpty() || currentStack.method_7960()) {
            startTime = -1L;
            lastStack = class_1799.field_8037;
        }
        if (components.isEmpty()) {
            return;
        }
        if (!currentStack.method_7960()) {
            if (lastStack.method_7960() || !class_1799.method_7973((class_1799)lastStack, (class_1799)currentStack)) {
                startTime = System.nanoTime();
                lastStack = currentStack.method_7972();
            } else if (startTime == -1L) {
                startTime = System.nanoTime();
            }
        }
        TooltipBackgroundComponent backgroundComponent = EnhancedTooltipsDrawer.getBackgroundComponent(components);
        components.removeIf(component -> component.method_32661(textRenderer) == 0 || component.method_32664(textRenderer) == 0);
        MatricesUtil matrices = new MatricesUtil(context.method_51448());
        ArrayList<TooltipPage> pageList = new ArrayList<TooltipPage>();
        float scale = 1.0f;
        scale = EnhancedTooltipsConfig.load().general.scaleFactor;
        int maxWidth = (int)((float)EnhancedTooltipsDrawer.getMaxWidth() / scale);
        int totalWidth = 0;
        int pageHeight = -2;
        int maxHeight = (int)((float)EnhancedTooltipsDrawer.getMaxHeight() / scale);
        int spacing = components.size() > 1 ? 4 : 0;
        pageHeight += spacing;
        TooltipPage page = new TooltipPage();
        for (class_5684 tooltipComponent : components) {
            int width = tooltipComponent.method_32664(textRenderer);
            int height = tooltipComponent.method_32661(textRenderer);
            if (width > maxWidth) {
                List<class_5684> wrappedComponents = EnhancedTooltipsDrawer.wrapComponent(tooltipComponent, textRenderer, maxWidth);
                Iterator<class_5684> iterator = wrappedComponents.iterator();
                while (iterator.hasNext()) {
                    class_5684 wrappedComponent = iterator.next();
                    int wrappedWidth = wrappedComponent.method_32664(textRenderer);
                    int wrappedHeight = wrappedComponent.method_32661(textRenderer);
                    if (pageHeight + wrappedHeight > maxHeight) {
                        pageList.add(page);
                        totalWidth += page.width;
                        page = new TooltipPage();
                        pageHeight = -2;
                    }
                    page.components.add(wrappedComponent);
                    page.height = pageHeight += wrappedHeight;
                    page.width = Math.max(page.width, wrappedWidth);
                }
                continue;
            }
            if (pageHeight + height > maxHeight) {
                pageList.add(page);
                totalWidth += page.width;
                page = new TooltipPage();
                pageHeight = -2;
            }
            page.components.add(tooltipComponent);
            page.height = pageHeight += height;
            page.width = Math.max(page.width, width);
        }
        if (!page.components.isEmpty()) {
            pageList.add(page);
            totalWidth += page.width;
        }
        int scaledOffset = (int)(12.0f * scale) - 12;
        Vector2ic vector2ic = positioner.method_47944(context.method_51421(), context.method_51443(), x + scaledOffset, y - scaledOffset, (int)((float)totalWidth * scale), (int)((float)((TooltipPage)pageList.getFirst()).height * scale));
        int n = vector2ic.x();
        int o = vector2ic.y();
        for (TooltipPage tooltipPage : pageList) {
            tooltipPage.x = n;
            tooltipPage.y = pageList.size() > 1 ? o - 32 : o - 6;
            n += tooltipPage.width + 12;
        }
        matrices.pushMatrix();
        if (!currentStack.method_7960() && EnhancedTooltipsConfig.load().popUpAnimation.enabled) {
            matrices.trans(x, y, 0.0f);
            float sec = EnhancedTooltipsConfig.load().popUpAnimation.time * 1000.0f;
            float elapsedTime = (float)(System.nanoTime() - startTime) / 1000000.0f / sec;
            float pop = 1.0f;
            if (elapsedTime < 0.5f) {
                pop = 1.0f + Math.abs((float)Math.sin((double)elapsedTime * Math.PI * 2.0)) * (EnhancedTooltipsConfig.load().popUpAnimation.magnitude / 10.0f * scale);
            }
            matrices.scal(pop, pop, 1.0f);
            matrices.trans(-x, -y, 0.0f);
        }
        matrices.scal(scale, scale, 1.0f);
        for (TooltipPage p : pageList) {
            if (pageList.getFirst() == p) {
                p.x = (int)((float)p.x / scale);
            }
            p.y = (int)((float)p.y / scale);
            if (backgroundComponent == null) {
                class_8002.method_47946((class_332)context, (int)p.x, (int)p.y, (int)p.width, (int)p.height, (int)400, (class_2960)class_2960.method_60656((String)"tooltip/background"));
                continue;
            }
            try {
                backgroundComponent.render(context, p.x, p.y, p.width, p.height, 400, pageList.indexOf(p));
            }
            catch (Exception e) {
                EnhancedTooltips.LOGGER.error("[EnhancedTooltips]", (Throwable)e);
            }
        }
        matrices.trans(0.0f, 0.0f, 400.0f);
        for (TooltipPage p : pageList) {
            int cx = p.x;
            int cy = p.y;
            for (class_5684 component2 : p.components) {
                try {
                    component2.method_32665(textRenderer, cx, cy, context.method_51448().method_23760().method_23761(), ((DrawContextAccessor)context).getVertexConsumers());
                    component2.method_32666(textRenderer, cx, cy, p.width, p.height, context);
                    cy += component2.method_32661(textRenderer);
                    if (p != pageList.getFirst() || component2 != p.components.getFirst() || components.size() <= 1) continue;
                    cy += spacing;
                }
                catch (Exception e) {
                    EnhancedTooltips.LOGGER.error("[EnhancedTooltips]", (Throwable)e);
                }
            }
        }
        matrices.popMatrix();
    }

    private static TooltipBackgroundComponent getBackgroundComponent(List<class_5684> components) {
        for (class_5684 component : components) {
            if (!(component instanceof TooltipBackgroundComponent)) continue;
            TooltipBackgroundComponent bgComponent = (TooltipBackgroundComponent)component;
            return bgComponent;
        }
        return null;
    }

    private static List<class_5684> wrapComponent(class_5684 component, class_327 textRenderer, int maxWidth) {
        ArrayList<class_5684> wrappedComponents = new ArrayList<class_5684>();
        if (component instanceof OrderedTextTooltipComponentAccessor) {
            OrderedTextTooltipComponentAccessor orderedTextTooltipComponent = (OrderedTextTooltipComponentAccessor)component;
            class_2561 text = EnhancedTooltipsTextVisitor.get(orderedTextTooltipComponent.getText());
            List lines = textRenderer.method_1728((class_5348)text, maxWidth);
            for (class_5481 line : lines) {
                wrappedComponents.add(class_5684.method_32662((class_5481)line));
            }
        } else {
            wrappedComponents.add(component);
        }
        return wrappedComponents;
    }

    private static class TooltipPage {
        private int x;
        private int y;
        private int width;
        private int height;
        private final List<class_5684> components;

        private TooltipPage() {
            this(0, 0, 0, 0, new ArrayList<class_5684>());
        }

        private TooltipPage(int x, int y, int width, int height, List<class_5684> components) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.components = components;
        }
    }
}

