/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import dev.ultimatchamp.enhancedtooltips.component.ModelViewerTooltipComponent;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public record ArmorTooltipComponent(ItemStack stack) implements ClientTooltipComponent
{
    public int getHeight(Font textRenderer) {
        Optional<ItemAttributeModifiers.Entry> opt;
        ItemAttributeModifiers c;
        int height = 0;
        if (ModelViewerTooltipComponent.getEquipmentSlot(this.stack).getType() == EquipmentSlot.Type.HUMANOID_ARMOR && (c = (ItemAttributeModifiers)this.stack.get(DataComponents.ATTRIBUTE_MODIFIERS)) != null && (opt = c.modifiers().stream().filter(i -> i.attribute().is(Attributes.ARMOR)).findAny()).isPresent() && opt.get().modifier().amount() > 0.0) {
            height = 9;
        }
        return height;
    }

    public int getWidth(Font textRenderer) {
        ItemAttributeModifiers c;
        int width = 0;
        if (ModelViewerTooltipComponent.getEquipmentSlot(this.stack).getType() == EquipmentSlot.Type.HUMANOID_ARMOR && (c = (ItemAttributeModifiers)this.stack.get(DataComponents.ATTRIBUTE_MODIFIERS)) != null) {
            Optional<ItemAttributeModifiers.Entry> opt = c.modifiers().stream().filter(i -> i.attribute().is(Attributes.ARMOR)).findAny();
            if (opt.isEmpty() || opt.get().modifier().amount() < 0.0) {
                return 0;
            }
            int prot = (int)opt.get().modifier().amount();
            width += prot / 2 * 9;
        }
        return width;
    }

    public void renderImage(Font textRenderer, int x, int y, int width, int height, GuiGraphics context) {
        ItemAttributeModifiers c;
        if (ModelViewerTooltipComponent.getEquipmentSlot(this.stack).getType() == EquipmentSlot.Type.HUMANOID_ARMOR && (c = (ItemAttributeModifiers)this.stack.get(DataComponents.ATTRIBUTE_MODIFIERS)) != null) {
            Optional<ItemAttributeModifiers.Entry> opt = c.modifiers().stream().filter(i -> i.attribute().is(Attributes.ARMOR)).findAny();
            if (opt.isEmpty()) {
                return;
            }
            int prot = (int)opt.get().modifier().amount();
            for (int j = 0; j < prot / 2; ++j) {
                Identifier identifier = Identifier.withDefaultNamespace((String)"hud/armor_full");
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.blitSprite(RenderPipelines.GUI_TEXTURED, identifier, x + j * 9, y, 9, 9);
            }
            if (prot % 2 == 1) {
                Identifier identifier = Identifier.withDefaultNamespace((String)"hud/armor_half");
                int n = x + prot / 2 * 9;
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.blitSprite(RenderPipelines.GUI_TEXTURED, identifier, n, y, 9, 9);
            }
        }
    }
}

