/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.object.banner.BannerFlagModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public record BannerPatternTooltipComponent(ItemStack stack) implements ClientTooltipComponent
{
    private TagKey<BannerPattern> getBannerPatternComponent() {
        return (TagKey)this.stack.get(DataComponents.PROVIDES_BANNER_PATTERNS);
    }

    public int getHeight(Font textRenderer) {
        return 45;
    }

    public int getWidth(Font textRenderer) {
        return 20;
    }

    public void renderImage(Font textRenderer, int x, int y, int width, int height, GuiGraphics context) {
        TagKey<BannerPattern> c = this.getBannerPatternComponent();
        ClientLevel world = Minecraft.getInstance().level;
        if (c == null || world == null) {
            return;
        }
        world.registryAccess().lookup(Registries.BANNER_PATTERN).flatMap(registry -> registry.getRandomElementOf(c, RandomSource.create())).ifPresent(entry -> {
            BannerPatternLayers patterns = new BannerPatternLayers(List.of(new BannerPatternLayers.Layer(entry, DyeColor.WHITE)));
            BannerFlagModel modelPart = new BannerFlagModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.STANDING_BANNER_FLAG));
            context.submitBannerPatternRenderState(modelPart, DyeColor.GRAY, patterns, x, y, x + 20, y + 40);
        });
    }
}

