/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import dev.ultimatchamp.enhancedtooltips.config.EnhancedTooltipsConfig;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;

public class FoodTooltipComponent
implements ClientTooltipComponent {
    private final ItemStack stack;
    private final EnhancedTooltipsConfig config;

    public FoodTooltipComponent(ItemStack stack) {
        this.stack = stack;
        this.config = EnhancedTooltipsConfig.load();
    }

    public Consumable getConsumableComponent() {
        return (Consumable)this.stack.get(DataComponents.CONSUMABLE);
    }

    public static FoodProperties getFoodComponent(ItemStack stack) {
        FoodProperties foodComponent = (FoodProperties)stack.getItem().components().get(DataComponents.FOOD);
        return foodComponent;
    }

    public int getHunger() {
        FoodProperties foodComponent = FoodTooltipComponent.getFoodComponent(this.stack);
        int hunger = 0;
        Consumable consumableComponent = this.getConsumableComponent();
        if (foodComponent != null && consumableComponent != null) {
            hunger = foodComponent.nutrition();
        }
        return hunger;
    }

    public int getSaturation() {
        FoodProperties foodComponent = FoodTooltipComponent.getFoodComponent(this.stack);
        int saturation = 0;
        int hunger = this.getHunger();
        if (foodComponent != null) {
            saturation = (int)((double)foodComponent.saturation() / ((double)hunger * 2.0) * 100.0);
        }
        return saturation;
    }

    public int getHeight(Font textRenderer) {
        int height = 0;
        FoodProperties foodComponent = FoodTooltipComponent.getFoodComponent(this.stack);
        Consumable consumableComponent = this.getConsumableComponent();
        if (foodComponent != null && consumableComponent != null) {
            if (this.config.foodAndDrinks.hungerTooltip) {
                height += 10;
            }
            if (this.config.foodAndDrinks.saturationTooltip) {
                height += 10;
            }
            if (this.config.foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.OFF) {
                return height;
            }
            for (ConsumeEffect entry : consumableComponent.onConsumeEffects()) {
                if (!(entry instanceof ApplyStatusEffectsConsumeEffect)) continue;
                ApplyStatusEffectsConsumeEffect applyEffectsConsumeEffect = (ApplyStatusEffectsConsumeEffect)entry;
                for (MobEffectInstance statusEffect : applyEffectsConsumeEffect.effects()) {
                    Objects.requireNonNull(textRenderer);
                    height += 9 + 1;
                }
            }
        }
        return height;
    }

    public int getWidth(Font textRenderer) {
        int foodWidth = 0;
        int effectsWidth = 0;
        FoodProperties foodComponent = FoodTooltipComponent.getFoodComponent(this.stack);
        int hunger = this.getHunger();
        int hungerLine = 0;
        if (this.config.foodAndDrinks.hungerTooltip) {
            float f = textRenderer.width((FormattedText)Component.translatable((String)"enhancedtooltips.tooltip.hunger")) + 1;
            Objects.requireNonNull(textRenderer);
            hungerLine = (int)(f + (float)(9 - 2) * ((float)hunger / 2.0f));
        }
        int saturationLine = 0;
        if (this.config.foodAndDrinks.saturationTooltip) {
            saturationLine = textRenderer.width((FormattedText)Component.translatable((String)"enhancedtooltips.tooltip.saturation"));
        }
        foodWidth = Math.max(hungerLine, saturationLine);
        if (this.config.foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.OFF) {
            return foodWidth;
        }
        if (foodComponent == null) {
            return 0;
        }
        Consumable consumableComponent = this.getConsumableComponent();
        if (consumableComponent == null) {
            return 0;
        }
        for (ConsumeEffect entry : consumableComponent.onConsumeEffects()) {
            if (!(entry instanceof ApplyStatusEffectsConsumeEffect)) continue;
            ApplyStatusEffectsConsumeEffect applyEffectsConsumeEffect = (ApplyStatusEffectsConsumeEffect)entry;
            for (MobEffectInstance statusEffect : applyEffectsConsumeEffect.effects()) {
                float probability = applyEffectsConsumeEffect.probability();
                MutableComponent text = Component.translatable((String)statusEffect.getDescriptionId()).append(" (99:99)");
                if (probability < 1.0f) {
                    text.append(" [100%]");
                }
                effectsWidth = Math.max(effectsWidth, textRenderer.width((FormattedText)text));
            }
        }
        if (effectsWidth != 0 && this.config.foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.WITH_ICONS) {
            Objects.requireNonNull(textRenderer);
            effectsWidth += 9 + 3;
        }
        return Math.max(foodWidth, effectsWidth);
    }

    public void renderImage(Font textRenderer, int x, int y, int width, int height, GuiGraphics context) {
        FoodProperties foodComponent = FoodTooltipComponent.getFoodComponent(this.stack);
        int hunger = this.getHunger();
        int saturation = this.getSaturation();
        Consumable consumableComponent = this.getConsumableComponent();
        if (consumableComponent == null) {
            return;
        }
        if (foodComponent == null) {
            return;
        }
        MutableComponent hungerText = Component.translatable((String)"enhancedtooltips.tooltip.hunger");
        MutableComponent saturationText = Component.translatable((String)"enhancedtooltips.tooltip.saturation", (Object[])new Object[]{saturation});
        int lineY = y;
        if (this.config.foodAndDrinks.hungerTooltip) {
            context.drawString(textRenderer, (Component)hungerText, x, lineY, -1, true);
            Identifier fullHunger = Identifier.fromNamespaceAndPath((String)"minecraft", (String)"hud/food_full");
            Identifier halfHunger = Identifier.fromNamespaceAndPath((String)"minecraft", (String)"hud/food_half");
            float fullHungers = (float)hunger / 2.0f;
            boolean hasHalfHunger = hunger % 2 != 0;
            int hungerWidth = textRenderer.width((FormattedText)hungerText) + 1;
            for (int i = 0; i < (int)fullHungers; ++i) {
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.blitSprite(RenderPipelines.GUI_TEXTURED, fullHunger, 9, 9, 0, 0, x + hungerWidth, lineY, 9, 9);
                Objects.requireNonNull(textRenderer);
                hungerWidth += 9 - 2;
            }
            if (hasHalfHunger) {
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.blitSprite(RenderPipelines.GUI_TEXTURED, halfHunger, 9, 9, 0, 0, x + hungerWidth, lineY, 9, 9);
            }
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
        if (this.config.foodAndDrinks.saturationTooltip) {
            context.drawString(textRenderer, (Component)saturationText, x + 2, lineY, -16711681, true);
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
        if (this.config.foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.OFF) {
            return;
        }
        for (ConsumeEffect entry : consumableComponent.onConsumeEffects()) {
            if (!(entry instanceof ApplyStatusEffectsConsumeEffect)) continue;
            ApplyStatusEffectsConsumeEffect applyEffectsConsumeEffect = (ApplyStatusEffectsConsumeEffect)entry;
            for (MobEffectInstance statusEffect : applyEffectsConsumeEffect.effects()) {
                int c = ((MobEffect)statusEffect.getEffect().value()).getColor() | 0xFF000000;
                Identifier effectTexture = Gui.getMobEffectSprite((Holder)statusEffect.getEffect());
                float probability = applyEffectsConsumeEffect.probability();
                MutableComponent effectText = probability >= 1.0f ? Component.translatable((String)statusEffect.getDescriptionId()).append(" (").append(MobEffectUtil.formatDuration((MobEffectInstance)statusEffect, (float)1.0f, (float)20.0f)).append(")") : Component.translatable((String)statusEffect.getDescriptionId()).append(" (").append(MobEffectUtil.formatDuration((MobEffectInstance)statusEffect, (float)1.0f, (float)20.0f)).append(")").append(" [").append(Math.round(probability * 100.0f) + "%").append("]");
                if (this.config.foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.WITH_ICONS) {
                    Objects.requireNonNull(textRenderer);
                    Objects.requireNonNull(textRenderer);
                    context.blitSprite(RenderPipelines.GUI_TEXTURED, effectTexture, x, lineY - 1, 9, 9);
                    Objects.requireNonNull(textRenderer);
                    context.drawString(textRenderer, (Component)effectText, x + 9 + 3, lineY, c, true);
                } else {
                    context.drawString(textRenderer, (Component)effectText, x, lineY, c, true);
                }
                Objects.requireNonNull(textRenderer);
                lineY += 9 + 1;
            }
        }
    }
}

