/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import dev.ultimatchamp.enhancedtooltips.config.EnhancedTooltipsConfig;
import java.util.Objects;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_9334;

public class FoodTooltipComponent
implements class_5684 {
    private final class_1799 stack;
    private final EnhancedTooltipsConfig config;

    public FoodTooltipComponent(class_1799 stack) {
        this.stack = stack;
        this.config = EnhancedTooltipsConfig.load();
    }

    public static class_4174 getFoodComponent(class_1799 stack) {
        class_4174 foodComponent = (class_4174)stack.method_7909().method_57347().method_57829(class_9334.field_50075);
        return foodComponent;
    }

    public int getHunger() {
        class_4174 foodComponent = FoodTooltipComponent.getFoodComponent(this.stack);
        int hunger = 0;
        if (foodComponent != null) {
            hunger = foodComponent.comp_2491();
        }
        return hunger;
    }

    public int getSaturation() {
        class_4174 foodComponent = FoodTooltipComponent.getFoodComponent(this.stack);
        int saturation = 0;
        int hunger = this.getHunger();
        if (foodComponent != null) {
            saturation = (int)((double)foodComponent.comp_2492() / ((double)hunger * 2.0) * 100.0);
        }
        return saturation;
    }

    public int method_32661() {
        int height = 0;
        class_4174 foodComponent = FoodTooltipComponent.getFoodComponent(this.stack);
        if (foodComponent != null) {
            if (this.config.foodAndDrinks.hungerTooltip) {
                height += 10;
            }
            if (this.config.foodAndDrinks.saturationTooltip) {
                height += 10;
            }
            if (this.config.foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.OFF) {
                return height;
            }
            for (class_4174.class_9423 entry : foodComponent.comp_2495()) {
                height += 10;
            }
        }
        return height;
    }

    public int method_32664(class_327 textRenderer) {
        int foodWidth = 0;
        int effectsWidth = 0;
        class_4174 foodComponent = FoodTooltipComponent.getFoodComponent(this.stack);
        int hunger = this.getHunger();
        int hungerLine = 0;
        if (this.config.foodAndDrinks.hungerTooltip) {
            float f = textRenderer.method_27525((class_5348)class_2561.method_43471((String)"enhancedtooltips.tooltip.hunger")) + 1;
            Objects.requireNonNull(textRenderer);
            hungerLine = (int)(f + (float)(9 - 2) * ((float)hunger / 2.0f));
        }
        int saturationLine = 0;
        if (this.config.foodAndDrinks.saturationTooltip) {
            saturationLine = textRenderer.method_27525((class_5348)class_2561.method_43471((String)"enhancedtooltips.tooltip.saturation"));
        }
        foodWidth = Math.max(hungerLine, saturationLine);
        if (this.config.foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.OFF) {
            return foodWidth;
        }
        if (foodComponent == null) {
            return 0;
        }
        for (class_4174.class_9423 entry : foodComponent.comp_2495()) {
            effectsWidth = Math.max(effectsWidth, textRenderer.method_27525((class_5348)class_2561.method_43471((String)entry.comp_2496().method_5586()).method_27693(" (99:99)")));
        }
        if (effectsWidth != 0 && this.config.foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.WITH_ICONS) {
            Objects.requireNonNull(textRenderer);
            effectsWidth += 9 + 3;
        }
        return Math.max(foodWidth, effectsWidth);
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
        class_4174 foodComponent = FoodTooltipComponent.getFoodComponent(this.stack);
        int hunger = this.getHunger();
        int saturation = this.getSaturation();
        if (foodComponent == null) {
            return;
        }
        class_5250 hungerText = class_2561.method_43471((String)"enhancedtooltips.tooltip.hunger");
        class_5250 saturationText = class_2561.method_43469((String)"enhancedtooltips.tooltip.saturation", (Object[])new Object[]{saturation});
        int lineY = y;
        if (this.config.foodAndDrinks.hungerTooltip) {
            context.method_51439(textRenderer, (class_2561)hungerText, x, lineY, -1, true);
            class_2960 fullHunger = class_2960.method_60655((String)"minecraft", (String)"hud/food_full");
            class_2960 halfHunger = class_2960.method_60655((String)"minecraft", (String)"hud/food_half");
            float fullHungers = (float)hunger / 2.0f;
            boolean hasHalfHunger = hunger % 2 != 0;
            int hungerWidth = textRenderer.method_27525((class_5348)hungerText) + 1;
            for (int i = 0; i < (int)fullHungers; ++i) {
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.method_52706(fullHunger, x + hungerWidth, lineY, 9, 9);
                Objects.requireNonNull(textRenderer);
                hungerWidth += 9 - 2;
            }
            if (hasHalfHunger) {
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.method_52706(halfHunger, x + hungerWidth, lineY, 9, 9);
            }
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
        if (this.config.foodAndDrinks.saturationTooltip) {
            context.method_51439(textRenderer, (class_2561)saturationText, x + 2, lineY, -16711681, true);
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
        if (this.config.foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.OFF) {
            return;
        }
        for (class_4174.class_9423 entry : foodComponent.comp_2495()) {
            class_1293 statusEffect = entry.comp_2496();
            int c = ((class_1291)statusEffect.method_5579().comp_349()).method_5556();
            class_1058 effectTexture = class_310.method_1551().method_18505().method_18663(statusEffect.method_5579());
            float probability = entry.comp_2497();
            class_5250 effectText = probability >= 1.0f ? class_2561.method_43471((String)statusEffect.method_5586()).method_27693(" (").method_10852(class_1292.method_5577((class_1293)statusEffect, (float)1.0f, (float)20.0f)).method_27693(")") : class_2561.method_43471((String)statusEffect.method_5586()).method_27693(" (").method_10852(class_1292.method_5577((class_1293)statusEffect, (float)1.0f, (float)20.0f)).method_27693(")").method_27693(" [").method_27693(Math.round(probability * 100.0f) + "%").method_27693("]");
            if (this.config.foodAndDrinks.effectsTooltip == EnhancedTooltipsConfig.EffectsTooltipMode.WITH_ICONS) {
                Objects.requireNonNull(textRenderer);
                Objects.requireNonNull(textRenderer);
                context.method_25298(x, lineY - 1, 0, 9, 9, effectTexture);
                Objects.requireNonNull(textRenderer);
                context.method_51439(textRenderer, (class_2561)effectText, x + 9 + 3, lineY, c, true);
            } else {
                context.method_51439(textRenderer, (class_2561)effectText, x, lineY, c, true);
            }
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
        }
    }
}

