/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import dev.ultimatchamp.enhancedtooltips.config.EnhancedTooltipsConfig;
import dev.ultimatchamp.enhancedtooltips.tooltip.TooltipHelper;
import dev.ultimatchamp.enhancedtooltips.util.BadgesUtils;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import org.joml.Matrix4f;

public class HeaderTooltipComponent
implements class_5684 {
    private static final int TEXTURE_SIZE = 16;
    private static final int SPACING = 4;
    private final class_1799 stack;
    private final class_2561 nameText;
    private final class_2561 rarityName;
    private final EnhancedTooltipsConfig config;

    public HeaderTooltipComponent(class_1799 stack) {
        this.stack = stack;
        this.nameText = TooltipHelper.getDisplayName(stack);
        this.rarityName = TooltipHelper.getRarityName(stack);
        this.config = EnhancedTooltipsConfig.load();
    }

    public int method_32661() {
        return this.getTitleOffset();
    }

    public int method_32664(class_327 textRenderer) {
        int rarityWidth = 0;
        if (this.config.general.rarityTooltip) {
            rarityWidth = textRenderer.method_27525((class_5348)this.rarityName);
        }
        int badgeWidth = 0;
        class_2561 badgeText = (class_2561)BadgesUtils.getBadgeText(this.stack).method_15442();
        if (this.config.general.itemBadges && !badgeText.method_44746().isEmpty()) {
            badgeWidth = textRenderer.method_27525((class_5348)badgeText) + 8;
        }
        int titleWidth = this.config.general.rarityTooltip ? textRenderer.method_27525((class_5348)this.nameText) + badgeWidth : Math.max(textRenderer.method_27525((class_5348)this.nameText), badgeWidth);
        return Math.max(titleWidth, rarityWidth) + this.getTitleOffset() + (this.getTitleOffset() - 16) / 2 + 2;
    }

    public int getTitleOffset() {
        return 26;
    }

    public void method_32665(class_327 textRenderer, int x, int y, Matrix4f matrix, class_4597.class_4598 vertexConsumers) {
        int startDrawX = x + this.getTitleOffset();
        int startDrawY = y;
        if (this.config.general.rarityTooltip) {
            startDrawY += 2;
        } else if (!this.config.general.itemBadges || ((class_2561)BadgesUtils.getBadgeText(this.stack).method_15442()).method_44746().isEmpty()) {
            int n = this.getTitleOffset();
            Objects.requireNonNull(textRenderer);
            startDrawY += (int)((float)(n - 9) / 2.0f);
        }
        textRenderer.method_30882(this.nameText, (float)startDrawX, (float)startDrawY, -1, true, matrix, (class_4597)vertexConsumers, class_327.class_6415.field_33993, 0, 0xF000F0);
        if (this.config.general.rarityTooltip) {
            Objects.requireNonNull(textRenderer);
            textRenderer.method_30882(this.rarityName, (float)startDrawX, (float)(startDrawY += 9 + 4), -1, true, matrix, (class_4597)vertexConsumers, class_327.class_6415.field_33993, 0, 0xF000F0);
        }
    }

    public void method_32666(class_327 textRenderer, int x, int y, class_332 context) {
        class_3545<class_2561, Integer> badgeText;
        int startDrawX = x + (this.getTitleOffset() - 16) / 2 - 1;
        int startDrawY = y + (this.getTitleOffset() - 16) / 2 - 1;
        float bounce = 0.0f;
        if (this.config.itemPreviewAnimation.enabled) {
            int sec = (int)(this.config.itemPreviewAnimation.time * 1000.0f);
            float time = (float)(System.currentTimeMillis() % (long)sec) / (float)sec;
            bounce = (float)Math.sin((double)time * Math.PI * 2.0) * (this.config.itemPreviewAnimation.magnitude * this.config.general.scaleFactor);
        }
        context.method_51427(this.stack, startDrawX, (int)((float)startDrawY - bounce));
        if (!this.config.general.itemBadges) {
            return;
        }
        if (!this.config.general.rarityTooltip) {
            Objects.requireNonNull(textRenderer);
            y += 9 + 4;
        }
        if (!((class_2561)(badgeText = BadgesUtils.getBadgeText(this.stack)).method_15442()).method_44746().isEmpty()) {
            this.drawBadge(textRenderer, (class_2561)badgeText.method_15442(), x, y, context, (Integer)badgeText.method_15441());
        }
    }

    private void drawBadge(class_327 textRenderer, class_2561 text, int x, int y, class_332 context, int fillColor) {
        int textWidth = textRenderer.method_27525((class_5348)text);
        Objects.requireNonNull(textRenderer);
        int textHeight = 9;
        int textX = x + this.getTitleOffset() + (!this.config.general.rarityTooltip ? 4 : textRenderer.method_27525((class_5348)this.nameText) + 4 + 2);
        Objects.requireNonNull(textRenderer);
        int textY = y - 9 + 8 + 2 + 1;
        context.method_25294(textX - 4, textY - 2, textX + textWidth + 4, textY + textHeight, BadgesUtils.darkenColor(fillColor, 0.9f));
        context.method_51439(textRenderer, text, textX, textY, -1, true);
        BadgesUtils.drawFrame(context, textX - 4, textY - 2, textWidth + 8, textHeight + 4, 400, BadgesUtils.darkenColor(fillColor, 0.8f));
    }
}

