/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.component;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public record PotionEffectTooltipComponent(ItemStack stack) implements ClientTooltipComponent
{
    public int getHeight(Font textRenderer) {
        int height = 0;
        PotionContents c = (PotionContents)this.stack.get(DataComponents.POTION_CONTENTS);
        if (c != null) {
            ArrayList effects = new ArrayList();
            ArrayList list = Lists.newArrayList();
            c.getAllEffects().forEach(i -> {
                effects.add(((MobEffect)i.getEffect().value()).getDisplayName());
                ((MobEffect)i.getEffect().value()).createModifiers(i.getAmplifier(), (attribute, modifier) -> list.add(new Pair(attribute, modifier)));
            });
            height += effects.size() * 10;
            if (effects.isEmpty()) {
                height += 10;
            }
            if (!list.isEmpty()) {
                height += 10;
            }
            height += list.size() * 10;
        }
        return height;
    }

    public int getWidth(Font textRenderer) {
        int width = 0;
        PotionContents c = (PotionContents)this.stack.get(DataComponents.POTION_CONTENTS);
        if (c != null) {
            ArrayList list = Lists.newArrayList();
            boolean isEmpty = true;
            for (MobEffectInstance effect : c.getAllEffects()) {
                isEmpty = false;
                width = Math.max(12 + textRenderer.width((FormattedText)this.getEffectText(effect, list::add)), width);
            }
            if (isEmpty) {
                width = Math.max(textRenderer.width((FormattedText)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY)), width);
            }
            if (!list.isEmpty()) {
                width = Math.max(textRenderer.width((FormattedText)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE)), width);
            }
            for (Pair pair : list) {
                Component modifierText = PotionEffectTooltipComponent.getModifierText((Pair<Holder<Attribute>, AttributeModifier>)pair);
                if (modifierText == null) continue;
                width = Math.max(3 + textRenderer.width((FormattedText)modifierText), width);
            }
        }
        return width;
    }

    public void renderImage(Font textRenderer, int x, int y, int width, int height, GuiGraphics context) {
        PotionContents c = (PotionContents)this.stack.get(DataComponents.POTION_CONTENTS);
        if (c == null) {
            return;
        }
        Objects.requireNonNull(textRenderer);
        int lineY = y - (9 + 1);
        ArrayList list = Lists.newArrayList();
        boolean isEmpty = true;
        for (MobEffectInstance effect : c.getAllEffects()) {
            isEmpty = false;
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
            ResourceLocation effectTexture = Gui.getMobEffectSprite((Holder)effect.getEffect());
            if (effectTexture == null) {
                return;
            }
            Objects.requireNonNull(textRenderer);
            Objects.requireNonNull(textRenderer);
            context.blitSprite(RenderPipelines.GUI_TEXTURED, effectTexture, x, lineY - 1, 9, 9);
            Component component = this.getEffectText(effect, list::add);
            Objects.requireNonNull(textRenderer);
            context.drawString(textRenderer, component, x + 9 + 3, lineY, -1, true);
        }
        if (isEmpty) {
            Objects.requireNonNull(textRenderer);
            context.drawString(textRenderer, (Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY), x, lineY += 9 + 1, -1, true);
        }
        if (!list.isEmpty()) {
            Objects.requireNonNull(textRenderer);
            context.drawString(textRenderer, (Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE), x, lineY += 9 + 1, -1, true);
        }
        for (Pair pair : list) {
            Objects.requireNonNull(textRenderer);
            lineY += 9 + 1;
            Component modifierText = PotionEffectTooltipComponent.getModifierText((Pair<Holder<Attribute>, AttributeModifier>)pair);
            if (modifierText == null) continue;
            context.drawString(textRenderer, modifierText, x + 3, lineY, -1, true);
        }
    }

    private Component getEffectText(MobEffectInstance effect, Consumer<Pair<Holder<Attribute>, AttributeModifier>> list) {
        MutableComponent effectText;
        Holder registryEntry = effect.getEffect();
        int amplifier = effect.getAmplifier();
        ((MobEffect)registryEntry.value()).createModifiers(amplifier, (attribute, modifier) -> list.accept(new Pair(attribute, modifier)));
        MutableComponent name = Component.translatable((String)((MobEffect)effect.getEffect().value()).getDescriptionId());
        MutableComponent mutableComponent = effectText = amplifier > 0 ? Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{name, Component.translatable((String)("potion.potency." + amplifier))}) : name;
        if (!effect.endsWithin(20)) {
            float durationMultiplier = ((Float)this.stack.getOrDefault(DataComponents.POTION_DURATION_SCALE, (Object)Float.valueOf(1.0f))).floatValue();
            effectText = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{effectText, MobEffectUtil.formatDuration((MobEffectInstance)effect, (float)durationMultiplier, (float)20.0f)});
        }
        return effectText;
    }

    private static Component getModifierText(Pair<Holder<Attribute>, AttributeModifier> pair) {
        AttributeModifier modifier = (AttributeModifier)pair.getSecond();
        double value = modifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && modifier.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? modifier.amount() : modifier.amount() * 100.0;
        MutableComponent modifierText = modifier.amount() > 0.0 ? Component.translatable((String)("attribute.modifier.plus." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE) : (modifier.amount() < 0.0 ? Component.translatable((String)("attribute.modifier.take." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value *= -1.0), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.RED) : null);
        return modifierText;
    }
}

