/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.enhancedtooltips.util;

import dev.ultimatchamp.enhancedtooltips.EnhancedTooltips;
import dev.ultimatchamp.enhancedtooltips.mixin.accessors.ClientWorldAccessor;
import dev.ultimatchamp.enhancedtooltips.mixin.accessors.ItemGroupAccessor;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class CreativeModeTabCollector {
    public static Map<CreativeModeTab, Collection<ItemStack>> collectTabs(@NotNull ClientLevel world) {
        LinkedHashMap<CreativeModeTab, Collection<ItemStack>> map = new LinkedHashMap<CreativeModeTab, Collection<ItemStack>>();
        FeatureFlagSet featureFlags = FeatureFlags.REGISTRY.allFlags();
        CreativeModeTab.ItemDisplayParameters parameters = new CreativeModeTab.ItemDisplayParameters(featureFlags, true, (HolderLookup.Provider)((ClientWorldAccessor)world).getNetworkHandler().registryAccess());
        for (CreativeModeTab group : CreativeModeTabs.allTabs()) {
            if (group.getType() == CreativeModeTab.Type.HOTBAR || group.getType() == CreativeModeTab.Type.INVENTORY) continue;
            try {
                CreativeModeTab.ItemDisplayBuilder builder = new CreativeModeTab.ItemDisplayBuilder(group, featureFlags);
                ResourceKey resourceKey = (ResourceKey)BuiltInRegistries.CREATIVE_MODE_TAB.getResourceKey((Object)group).orElseThrow(() -> new IllegalStateException("Unregistered creative tab: " + String.valueOf(group)));
                EventHooks.onCreativeModeTabBuildContents((CreativeModeTab)group, (ResourceKey)resourceKey, (CreativeModeTab.DisplayItemsGenerator)((ItemGroupAccessor)group).getEntryCollector(), (CreativeModeTab.ItemDisplayParameters)parameters, (stack, visibility) -> {
                    if (visibility == CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY) {
                        return;
                    }
                    builder.accept(stack, visibility);
                });
                map.put(group, builder.tabContents);
            }
            catch (Throwable throwable) {
                EnhancedTooltips.LOGGER.error("Failed to collect creative tab: {}", (Object)group, (Object)throwable);
            }
        }
        return map;
    }
}

