/*
 * Decompiled with CFR 0.152.
 */
package com.chocoboy.create_henry.content.blocks.kinetics.furnace_engine;

import com.chocoboy.create_henry.content.blocks.kinetics.furnace_engine.FurnaceEngineBlock;
import com.chocoboy.create_henry.content.blocks.kinetics.furnace_engine.FurnaceEngineValueBox;
import com.chocoboy.create_henry.content.blocks.kinetics.furnace_engine.PoweredFlywheelBlockEntity;
import com.chocoboy.create_henry.content.blocks.kinetics.furnace_engine.SmokeJetParticleData;
import com.chocoboy.create_henry.registry.HenryBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class FurnaceEngineBlockEntity
extends SmartBlockEntity {
    protected ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    public WeakReference<PoweredFlywheelBlockEntity> target = new WeakReference<Object>(null);
    public WeakReference<AbstractFurnaceBlockEntity> source = new WeakReference<Object>(null);
    float prevAngle = 0.0f;
    int delayedTimer;

    public FurnaceEngineBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)CreateLang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new FurnaceEngineValueBox());
        this.movementDirection.onlyActiveWhen(() -> {
            PoweredFlywheelBlockEntity flywheel = this.getFlywheel();
            return flywheel == null || !flywheel.hasSource();
        });
        this.movementDirection.withCallback($ -> this.onDirectionChanged());
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
    }

    public void tick() {
        Direction facing;
        super.tick();
        PoweredFlywheelBlockEntity flywheel = this.getFlywheel();
        AbstractFurnaceBlockEntity furnace = this.getFurnace();
        if (furnace != null && flywheel != null) {
            float efficiency;
            float f = efficiency = furnace.f_58318_ > 0 && furnace.f_58319_ > 0 ? 1.0f : 0.0f;
            if (efficiency > 0.0f && this.delayedTimer < 5) {
                ++this.delayedTimer;
            } else if (this.delayedTimer > 0) {
                --this.delayedTimer;
            }
            boolean verticalTarget = false;
            BlockState flywheelState = flywheel.m_58900_();
            Direction.Axis targetAxis = Direction.Axis.X;
            Block var7 = flywheelState.m_60734_();
            if (var7 instanceof IRotate) {
                IRotate ir = (IRotate)var7;
                targetAxis = ir.getRotationAxis(flywheelState);
            }
            verticalTarget = targetAxis == Direction.Axis.Y;
            BlockState blockState = this.m_58900_();
            if (HenryBlocks.FURNACE_ENGINE.has(blockState)) {
                int conveyedSpeedLevel;
                float delayedEfficiency;
                Direction facing2 = SteamEngineBlock.getFacing((BlockState)blockState);
                if (facing2.m_122434_() == Direction.Axis.Y) {
                    facing2 = (Direction)blockState.m_61143_((Property)SteamEngineBlock.f_54117_);
                }
                float f2 = delayedEfficiency = this.delayedTimer > 1 ? 1.0f : 0.0f;
                if (delayedEfficiency > 0.0f) {
                    this.award(AllAdvancements.STEAM_ENGINE);
                }
                int n = delayedEfficiency == 0.0f ? 1 : (conveyedSpeedLevel = verticalTarget ? 1 : (int)GeneratingKineticBlockEntity.convertToDirection((float)1.0f, (Direction)facing2));
                if (targetAxis == Direction.Axis.Z) {
                    conveyedSpeedLevel *= -1;
                }
                if (this.movementDirection.get() == WindmillBearingBlockEntity.RotationDirection.COUNTER_CLOCKWISE) {
                    conveyedSpeedLevel *= -1;
                }
                float flywheelSpeed = flywheel.getTheoreticalSpeed();
                if (flywheel.hasSource() && flywheelSpeed != 0.0f && conveyedSpeedLevel != 0 && flywheelSpeed > 0.0f != conveyedSpeedLevel > 0) {
                    this.movementDirection.setValue(1 - ((WindmillBearingBlockEntity.RotationDirection)this.movementDirection.get()).ordinal());
                    conveyedSpeedLevel *= -1;
                }
                flywheel.update(this.f_58858_, conveyedSpeedLevel, delayedEfficiency);
                if (this.f_58857_.f_46443_) {
                    DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::spawnParticles);
                }
            }
        } else if (!this.f_58857_.m_5776_() && flywheel != null && flywheel.m_58899_().m_121996_((Vec3i)this.f_58858_).equals((Object)flywheel.enginePos) && flywheel.engineEfficiency != 0.0f && this.f_58857_.m_46749_(this.f_58858_.m_121945_((facing = SteamEngineBlock.getFacing((BlockState)this.m_58900_())).m_122424_()))) {
            flywheel.update(this.f_58858_, 0, 0.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        Float targetAngle = this.getTargetAngle();
        PoweredFlywheelBlockEntity ste = (PoweredFlywheelBlockEntity)((Object)this.target.get());
        if (ste != null && ste.isPoweredBy(this.f_58858_) && targetAngle != null) {
            float angle;
            angle += (angle = AngleHelper.deg((double)targetAngle.floatValue())) < 0.0f ? -105.0f : 285.0f;
            angle %= 360.0f;
            PoweredFlywheelBlockEntity flywheel = this.getFlywheel();
            if (flywheel != null && flywheel.getSpeed() != 0.0f) {
                if (!(angle >= 0.0f) || this.prevAngle > 180.0f && angle < 180.0f) {
                    if (!(!(angle < 0.0f) || this.prevAngle < -180.0f && angle > -180.0f)) {
                        this.prevAngle = angle;
                    } else {
                        AbstractFurnaceBlockEntity sourceBE = (AbstractFurnaceBlockEntity)this.source.get();
                        if (sourceBE != null) {
                            float volume = 1.5f;
                            float pitch = 0.28f + this.f_58857_.f_46441_.m_188501_() * 0.1f;
                            this.f_58857_.m_7785_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), SoundEvents.f_144098_, SoundSource.BLOCKS, volume, pitch, false);
                            AllSoundEvents.STEAM.playAt(this.f_58857_, (Vec3i)this.f_58858_, volume / 16.0f, 0.25f, false);
                        }
                        Direction facing = FurnaceEngineBlock.getFacing(this.m_58900_());
                        Vec3 offset = VecHelper.rotate((Vec3)new Vec3(0.0, 0.0, 1.0).m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.f_58857_.f_46441_, (float)1.0f).m_82542_(1.0, 1.0, 0.0).m_82541_().m_82490_(0.5)), (double)AngleHelper.verticalAngle((Direction)facing), (Direction.Axis)Direction.Axis.X);
                        offset = VecHelper.rotate((Vec3)offset, (double)AngleHelper.horizontalAngle((Direction)facing), (Direction.Axis)Direction.Axis.Y);
                        Vec3 v = offset.m_82490_(0.5).m_82549_(Vec3.m_82512_((Vec3i)this.f_58858_));
                        Vec3 m = offset.m_82546_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(0.75));
                        this.f_58857_.m_7106_((ParticleOptions)new SmokeJetParticleData(0.5f), v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
                        this.prevAngle = angle;
                    }
                } else {
                    this.prevAngle = angle;
                }
            }
        }
    }

    private void onDirectionChanged() {
    }

    public PoweredFlywheelBlockEntity getFlywheel() {
        PoweredFlywheelBlockEntity flywheel = (PoweredFlywheelBlockEntity)((Object)this.target.get());
        if (flywheel == null || flywheel.m_58901_() || !flywheel.canBePoweredBy(this.f_58858_)) {
            PoweredFlywheelBlockEntity ps;
            Direction facing;
            BlockEntity anyShaftAt;
            if (flywheel != null) {
                this.target = new WeakReference<Object>(null);
            }
            if ((anyShaftAt = this.f_58857_.m_7702_(this.f_58858_.m_5484_(facing = FurnaceEngineBlock.getFacing(this.m_58900_()), 2))) instanceof PoweredFlywheelBlockEntity && (ps = (PoweredFlywheelBlockEntity)anyShaftAt).canBePoweredBy(this.f_58858_)) {
                flywheel = ps;
                this.target = new WeakReference<PoweredFlywheelBlockEntity>(ps);
            }
        }
        return flywheel;
    }

    public AbstractFurnaceBlockEntity getFurnace() {
        AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)this.source.get();
        if (furnace == null || furnace.m_58901_()) {
            Direction facing;
            BlockEntity be;
            if (furnace != null) {
                this.source = new WeakReference<Object>(null);
            }
            if ((be = this.f_58857_.m_7702_(this.f_58858_.m_121945_((facing = FurnaceEngineBlock.getFacing(this.m_58900_())).m_122424_()))) instanceof AbstractFurnaceBlockEntity) {
                AbstractFurnaceBlockEntity furnaceBe;
                furnace = furnaceBe = (AbstractFurnaceBlockEntity)be;
                this.source = new WeakReference<AbstractFurnaceBlockEntity>(furnaceBe);
            }
        }
        return furnace;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Float getTargetAngle() {
        float angle = 0.0f;
        BlockState blockState = this.m_58900_();
        if (!HenryBlocks.FURNACE_ENGINE.has(blockState)) {
            return null;
        }
        Direction facing = SteamEngineBlock.getFacing((BlockState)blockState);
        PoweredFlywheelBlockEntity flywheel = this.getFlywheel();
        Direction.Axis facingAxis = facing.m_122434_();
        Direction.Axis axis = Direction.Axis.Y;
        if (flywheel == null) {
            return null;
        }
        axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)flywheel);
        angle = KineticBlockEntityRenderer.getAngleForBe((KineticBlockEntity)flywheel, (BlockPos)flywheel.m_58899_(), (Direction.Axis)axis);
        if (axis == facingAxis) {
            return null;
        }
        if (axis.m_122479_() && facingAxis == Direction.Axis.X ^ facing.m_122421_() == Direction.AxisDirection.POSITIVE) {
            angle *= -1.0f;
        }
        if (axis == Direction.Axis.X && facing == Direction.DOWN) {
            angle *= -1.0f;
        }
        return Float.valueOf(angle);
    }

    public void remove() {
        PoweredFlywheelBlockEntity flywheel = this.getFlywheel();
        if (flywheel != null) {
            flywheel.remove(this.f_58858_);
        }
        super.remove();
    }
}

