/*
 * Decompiled with CFR 0.152.
 */
package com.chocoboy.create_henry.content.blocks.kinetics.furnace_engine;

import com.chocoboy.create_henry.content.blocks.kinetics.furnace_engine.FurnaceEngineBlockEntity;
import com.chocoboy.create_henry.content.blocks.kinetics.furnace_engine.PoweredFlywheelBlockEntity;
import com.chocoboy.create_henry.registry.HenryPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlock;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.Objects;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FurnaceEngineVisual
extends AbstractBlockEntityVisual<FurnaceEngineBlockEntity>
implements SimpleDynamicVisual {
    protected final TransformedInstance piston;
    protected final TransformedInstance linkage;
    protected final TransformedInstance connector;
    private Float lastAngle = Float.valueOf(Float.NaN);
    private Direction.Axis lastAxis = null;

    public FurnaceEngineVisual(VisualizationContext context, FurnaceEngineBlockEntity blockEntity, float partialTick) {
        super(context, (BlockEntity)blockEntity, partialTick);
        this.piston = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)HenryPartialModels.ENGINE_PISTON)).createInstance();
        this.linkage = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)HenryPartialModels.ENGINE_LINKAGE)).createInstance();
        this.connector = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)HenryPartialModels.ENGINE_CONNECTOR)).createInstance();
        this.animate();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate();
    }

    public void animate() {
        Float angle = ((FurnaceEngineBlockEntity)this.blockEntity).getTargetAngle();
        Direction.Axis axis = Direction.Axis.Y;
        PoweredFlywheelBlockEntity flywheel = ((FurnaceEngineBlockEntity)this.blockEntity).getFlywheel();
        if (flywheel != null) {
            axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)flywheel);
        }
        if (Objects.equals(angle, this.lastAngle) && this.lastAxis == axis) {
            return;
        }
        this.lastAngle = angle;
        this.lastAxis = axis;
        if (angle == null) {
            this.piston.setVisible(false);
            this.linkage.setVisible(false);
            this.connector.setVisible(false);
            return;
        }
        Direction facing = SteamEngineBlock.getFacing((BlockState)this.blockState);
        Direction.Axis facingAxis = facing.m_122434_();
        boolean roll90 = facingAxis.m_122479_() && axis == Direction.Axis.Y || facingAxis.m_122478_() && axis == Direction.Axis.Z;
        float sine = Mth.m_14031_((float)angle.floatValue());
        float sine2 = Mth.m_14031_((float)(angle.floatValue() - 1.5707964f));
        float piston = (1.0f - sine) / 4.0f * 24.0f / 16.0f;
        ((TransformedInstance)this.transformed(this.piston, facing, roll90).translate(0.0, (double)piston, 0.0)).setChanged();
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.transformed(this.linkage, facing, roll90).center()).translate(0.0f, 1.0f, 0.0f).uncenter()).translate(0.0f, piston, 0.0f).translate(0.0, 0.25, 0.5)).rotateXDegrees(sine2 * 23.0f)).translate(0.0, -0.25, -0.5)).setChanged();
        ((TransformedInstance)((TransformedInstance)this.transformed(this.connector, facing, roll90).translate(0.0f, 2.0f, 0.0f).center()).rotateX(-angle.floatValue() + 1.5707964f).uncenter()).setChanged();
    }

    protected TransformedInstance transformed(TransformedInstance modelData, Direction facing, boolean roll90) {
        return (TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)modelData.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing))).rotateXDegrees(AngleHelper.verticalAngle((Direction)facing) + 90.0f)).rotateYDegrees((float)(roll90 ? -90.0 : 0.0))).uncenter();
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.piston, this.linkage, this.connector});
    }

    protected void _delete() {
        this.piston.delete();
        this.linkage.delete();
        this.connector.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept((Instance)this.piston);
        consumer.accept((Instance)this.linkage);
        consumer.accept((Instance)this.connector);
    }
}

