/*
 * Decompiled with CFR 0.152.
 */
package com.chocoboy.create_henry.content.blocks.kinetics.furnace_engine;

import com.chocoboy.create_henry.content.blocks.kinetics.furnace_engine.FurnaceEngineBlock;
import com.chocoboy.create_henry.content.blocks.kinetics.furnace_engine.PoweredFlywheelBlockEntity;
import com.chocoboy.create_henry.registry.HenryBlockEntityTypes;
import com.chocoboy.create_henry.registry.HenryBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PoweredFlywheelBlock
extends RotatedPillarKineticBlock
implements IBE<PoweredFlywheelBlockEntity> {
    public PoweredFlywheelBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public Class<PoweredFlywheelBlockEntity> getBlockEntityClass() {
        return PoweredFlywheelBlockEntity.class;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.LARGE_GEAR.get((Direction.Axis)pState.m_61143_((Property)AXIS));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockEntityType<? extends PoweredFlywheelBlockEntity> getBlockEntityType() {
        return (BlockEntityType)HenryBlockEntityTypes.POWERED_FLYWHEEL.get();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == this.getRotationAxis(state);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.m_61143_((Property)AXIS);
    }

    public float getParticleTargetRadius() {
        return 2.0f;
    }

    public float getParticleInitialRadius() {
        return 1.75f;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return AllBlocks.FLYWHEEL.asStack();
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!PoweredFlywheelBlock.stillValid(pState, (LevelReader)pLevel, pPos)) {
            pLevel.m_7731_(pPos, (BlockState)AllBlocks.FLYWHEEL.getDefaultState().m_61124_((Property)RotatedPillarKineticBlock.AXIS, (Comparable)((Direction.Axis)pState.m_61143_((Property)AXIS))), 3);
        }
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return PoweredFlywheelBlock.stillValid(pState, pLevel, pPos);
    }

    public static boolean stillValid(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        for (Direction d : Iterate.directions) {
            BlockPos enginePos;
            BlockState engineState;
            Block block;
            if (d.m_122434_() == pState.m_61143_((Property)AXIS) || !((block = (engineState = pLevel.m_8055_(enginePos = pPos.m_5484_(d, 2))).m_60734_()) instanceof FurnaceEngineBlock)) continue;
            FurnaceEngineBlock engine = (FurnaceEngineBlock)block;
            if (!FurnaceEngineBlock.getFlywheelPos(engineState, enginePos).equals((Object)pPos) || !FurnaceEngineBlock.isFlywheelValid(engineState, pState)) continue;
            return true;
        }
        return false;
    }

    public static BlockState getEquivalent(BlockState stateForPlacement, Direction.Axis preferredAxis) {
        return (BlockState)HenryBlocks.POWERED_FLYWHEEL.getDefaultState().m_61124_((Property)AXIS, (Comparable)preferredAxis);
    }
}

