/*
 * Decompiled with CFR 0.152.
 */
package com.chocoboy.create_henry.content.blocks.kinetics.furnace_engine;

import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class PoweredFlywheelBlockEntity
extends GeneratingKineticBlockEntity {
    public BlockPos enginePos;
    public float engineEfficiency;
    public int movementDirection = 1;
    public int initialTicks = 3;
    public Block capacityKey;
    LerpedFloat visualSpeed = LerpedFloat.linear();
    float angle;

    public PoweredFlywheelBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void tick() {
        super.tick();
        if (this.initialTicks > 0) {
            --this.initialTicks;
        }
        if (this.f_58857_.f_46443_) {
            float targetSpeed = this.getSpeed();
            this.visualSpeed.updateChaseTarget(targetSpeed);
            this.visualSpeed.tickChaser();
            this.angle += this.visualSpeed.getValue() * 3.0f / 10.0f;
            this.angle %= 360.0f;
        } else {
            this.m_58900_().m_222963_((ServerLevel)this.f_58857_, this.m_58899_(), this.f_58857_.m_213780_());
        }
    }

    public void update(BlockPos sourcePos, int direction, float efficiency) {
        BlockPos key;
        this.enginePos = key = this.f_58858_.m_121996_((Vec3i)sourcePos);
        float prev = this.engineEfficiency;
        this.engineEfficiency = efficiency;
        int prevDirection = this.movementDirection;
        if (Mth.m_14033_((float)efficiency, (float)prev) && prevDirection == direction) {
            return;
        }
        this.capacityKey = this.f_58857_.m_8055_(sourcePos).m_60734_();
        this.movementDirection = direction;
        this.updateGeneratedRotation();
    }

    public void remove(BlockPos sourcePos) {
        if (!this.isPoweredBy(sourcePos)) {
            return;
        }
        this.enginePos = null;
        this.engineEfficiency = 0.0f;
        this.movementDirection = 0;
        this.capacityKey = null;
        this.updateGeneratedRotation();
    }

    public boolean canBePoweredBy(BlockPos globalPos) {
        return this.initialTicks == 0 && (this.enginePos == null || this.isPoweredBy(globalPos));
    }

    public boolean isPoweredBy(BlockPos globalPos) {
        BlockPos key = this.f_58858_.m_121996_((Vec3i)globalPos);
        return key.equals((Object)this.enginePos);
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("Direction", this.movementDirection);
        if (this.initialTicks > 0) {
            compound.m_128405_("Warmup", this.initialTicks);
        }
        if (this.enginePos != null && this.capacityKey != null) {
            compound.m_128365_("EnginePos", (Tag)NbtUtils.m_129224_((BlockPos)this.enginePos));
            compound.m_128350_("EnginePower", this.engineEfficiency);
            compound.m_128359_("EngineType", CatnipServices.REGISTRIES.getKeyOrThrow(this.capacityKey).toString());
        }
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.movementDirection = compound.m_128451_("Direction");
        this.initialTicks = compound.m_128451_("Warmup");
        this.enginePos = null;
        this.engineEfficiency = 0.0f;
        if (compound.m_128441_("EnginePos")) {
            this.enginePos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("EnginePos"));
            this.engineEfficiency = compound.m_128457_("EnginePower");
            this.capacityKey = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(compound.m_128461_("EngineType")));
        }
        if (clientPacket) {
            this.visualSpeed.chase((double)this.getGeneratedSpeed(), 0.015625, LerpedFloat.Chaser.EXP);
        }
    }

    public float getGeneratedSpeed() {
        return this.getCombinedCapacity() > 0.0f ? (float)(this.movementDirection * 8 * this.getSpeedModifier()) : 0.0f;
    }

    private float getCombinedCapacity() {
        return this.capacityKey == null ? 0.0f : (float)((double)this.engineEfficiency * BlockStressValues.getCapacity((Block)this.capacityKey));
    }

    private int getSpeedModifier() {
        return (int)(1.0 + (this.engineEfficiency >= 1.0f ? 3.0 : Math.min(2.0, Math.floor(this.engineEfficiency * 4.0f))));
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = this.getCombinedCapacity() / (float)this.getSpeedModifier();
        return capacity;
    }

    public int getRotationAngleOffset(Direction.Axis axis) {
        int combinedCoords = axis.m_7863_(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_());
        return super.getRotationAngleOffset(axis) + (combinedCoords % 2 == 0 ? 180 : 0);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return false;
    }

    public boolean addToEngineTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }
}

