/*
 * Decompiled with CFR 0.152.
 */
package com.chocoboy.create_henry.content.blocks.kinetics.industrial_brake;

import com.chocoboy.create_henry.content.blocks.kinetics.industrial_brake.IndustrialBrakeBlock;
import com.chocoboy.create_henry.content.blocks.kinetics.industrial_brake.IndustrialBrakeScrollValueBehaviour;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class IndustrialBrakeBlockEntity
extends GeneratingKineticBlockEntity {
    public static final int MAX_STRESS_PER_RPM = 256;
    protected ScrollValueBehaviour impactValue;

    public IndustrialBrakeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.impactValue = new IndustrialBrakeScrollValueBehaviour((Component)Component.m_237113_((String)"SU Drawn"), (SmartBlockEntity)this, (ValueBoxTransform)new MotorValueBox());
        this.impactValue.between(0, 256);
        this.impactValue.value = 0;
        this.impactValue.withCallback(v -> {
            this.updateGeneratedRotation();
            this.getOrCreateNetwork().updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
            this.getOrCreateNetwork().updateStress();
        });
        this.impactValue.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add((BlockEntityBehaviour)this.impactValue);
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() && this.impactValue != null && this.impactValue.getValue() > 0) {
            this.reActivateSource = true;
            this.updateGeneratedRotation();
        }
    }

    public void remove() {
        if (this.f_58857_ != null && this.hasNetwork()) {
            KineticNetwork net = this.getOrCreateNetwork();
            if (net != null) {
                net.updateStressFor((KineticBlockEntity)this, 0.0f);
            }
            if (net != null) {
                net.updateStress();
            }
        }
        super.remove();
    }

    public float calculateAddedStressCapacity() {
        return 0.0f;
    }

    public float calculateStressApplied() {
        float draw = this.impactValue.getValue();
        float speed = Math.abs(this.getTheoreticalSpeed());
        if (speed == 0.0f) {
            return 0.0f;
        }
        return draw / speed;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled()) {
            return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        }
        int draw = this.impactValue.getValue();
        if (draw == 0) {
            return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        }
        CreateLang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.stressImpact", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.number((double)draw).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.RED).space().add(Component.m_237113_((String)"at current selected stress").m_130940_(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }

    class MotorValueBox
    extends ValueBoxTransform.Sided {
        MotorValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Direction facing = (Direction)state.m_61143_((Property)IndustrialBrakeBlock.FACING);
            return super.getLocalOffset(level, pos, state).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(-0.0625));
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            super.rotate(level, pos, state, ms);
            Direction facing = (Direction)state.m_61143_((Property)IndustrialBrakeBlock.FACING);
            if (facing.m_122434_() == Direction.Axis.Y) {
                return;
            }
            if (this.getSide() != Direction.UP) {
                return;
            }
            TransformStack.of((PoseStack)ms).rotateZDegrees(-AngleHelper.horizontalAngle((Direction)facing) + 180.0f);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.m_61143_((Property)IndustrialBrakeBlock.FACING);
            if (facing.m_122434_() != Direction.Axis.Y && direction == Direction.DOWN) {
                return false;
            }
            return direction.m_122434_() != facing.m_122434_();
        }
    }
}

