/*
 * Decompiled with CFR 0.152.
 */
package com.chocoboy.create_henry.content.blocks.kinetics.kinetic_motor;

import com.chocoboy.create_henry.content.blocks.kinetics.kinetic_motor.KineticMotorBlock;
import com.chocoboy.create_henry.content.blocks.kinetics.kinetic_motor.KineticMotorScrollValueBehaviour;
import com.chocoboy.create_henry.registry.HenryBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class KineticMotorBlockEntity
extends GeneratingKineticBlockEntity {
    protected ScrollValueBehaviour generatedSpeed;

    public KineticMotorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 32;
        this.generatedSpeed = new KineticMotorScrollValueBehaviour((Component)CreateLang.translateDirect((String)"kinetics.creative_motor.rotation_speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new MotorValueBox());
        this.generatedSpeed.between(-max, max);
        this.generatedSpeed.value = 16;
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add((BlockEntityBehaviour)this.generatedSpeed);
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!IRotate.StressImpact.isEnabled()) {
            return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        }
        float stressBase = this.calculateAddedStressCapacity();
        if (Mth.m_14033_((float)stressBase, (float)0.0f)) {
            return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        }
        CreateLang.translate((String)"gui.goggles.generator_stats", (Object[])new Object[0]).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.number((double)stressBase).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add(CreateLang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }

    public float getGeneratedSpeed() {
        return !HenryBlocks.KINETIC_MOTOR.has(this.m_58900_()) ? 0.0f : KineticMotorBlockEntity.convertToDirection((float)this.generatedSpeed.getValue(), (Direction)((Direction)this.m_58900_().m_61143_((Property)KineticMotorBlock.FACING)));
    }

    class MotorValueBox
    extends ValueBoxTransform.Sided {
        MotorValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)12.5);
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            Direction facing = (Direction)state.m_61143_((Property)KineticMotorBlock.FACING);
            return super.getLocalOffset(level, pos, state).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(-0.0625));
        }

        public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
            super.rotate(level, pos, state, ms);
            Direction facing = (Direction)state.m_61143_((Property)KineticMotorBlock.FACING);
            if (facing.m_122434_() != Direction.Axis.Y && this.getSide() == Direction.UP) {
                TransformStack.of((PoseStack)ms).rotateZDegrees(-AngleHelper.horizontalAngle((Direction)facing) + 180.0f);
            }
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            Direction facing = (Direction)state.m_61143_((Property)KineticMotorBlock.FACING);
            if (facing.m_122434_() != Direction.Axis.Y && direction == Direction.DOWN) {
                return false;
            }
            return direction.m_122434_() != facing.m_122434_();
        }
    }
}

