/*
 * Decompiled with CFR 0.152.
 */
package com.chocoboy.create_henry.registry;

import com.chocoboy.create_henry.HenryCreate;
import com.chocoboy.create_henry.compat.HenryMods;
import com.chocoboy.create_henry.content.recipes.DragonBreathingRecipe;
import com.chocoboy.create_henry.content.recipes.FreezingRecipe;
import com.chocoboy.create_henry.content.recipes.SandingRecipe;
import com.chocoboy.create_henry.content.recipes.SeethingRecipe;
import com.chocoboy.create_henry.content.recipes.WitheringRecipe;
import com.chocoboy.create_henry.registry.HenryRecipeTypes;
import com.chocoboy.create_henry.registry.HenryTags;
import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.trains.CubeParticleData;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class HenryFanProcessingTypes {
    public static final SandingType SANDING = HenryFanProcessingTypes.register("sanding", new SandingType());
    public static final FreezingType FREEZING = HenryFanProcessingTypes.register("freezing", new FreezingType());
    public static final SeethingType SEETHING = HenryFanProcessingTypes.register("seething", new SeethingType());
    public static final WitheringType WITHERING = HenryFanProcessingTypes.register("withering", new WitheringType());
    public static final DragonBreathingType DRAGON_BREATHING = HenryFanProcessingTypes.register("dragon_breathing", new DragonBreathingType());
    private static final Map<String, FanProcessingType> LEGACY_NAME_MAP;

    private static <T extends FanProcessingType> T register(String name, T type) {
        return (T)((FanProcessingType)Registry.m_122965_((Registry)CreateBuiltInRegistries.FAN_PROCESSING_TYPE, (ResourceLocation)HenryCreate.asResource(name), type));
    }

    @Nullable
    public static FanProcessingType ofLegacyName(String name) {
        return LEGACY_NAME_MAP.get(name);
    }

    @Nullable
    public static FanProcessingType parseLegacy(String str) {
        FanProcessingType type = HenryFanProcessingTypes.ofLegacyName(str);
        if (type != null) {
            return type;
        }
        return FanProcessingType.parse((String)str);
    }

    public static void init() {
    }

    static {
        Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
        map.put((Object)"SANDING", (Object)SANDING);
        map.put((Object)"FREEZING", (Object)FREEZING);
        map.put((Object)"SEETHING", (Object)SEETHING);
        map.put((Object)"WITHERING", (Object)WITHERING);
        map.put((Object)"DRAGON_BREATHING", (Object)DRAGON_BREATHING);
        map.trim();
        LEGACY_NAME_MAP = map;
    }

    public static class SandingType
    implements FanProcessingType {
        private static final SandingRecipe.SandingWrapper SANDING_WRAPPER = new SandingRecipe.SandingWrapper();

        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.m_6425_(pos);
            if (HenryTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_SANDING.matches(fluidState)) {
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            return HenryTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_SANDING.matches(blockState);
        }

        public int getPriority() {
            return 691000;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            SANDING_WRAPPER.m_6836_(0, stack);
            Optional recipe = HenryRecipeTypes.SANDING.find(SANDING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            SANDING_WRAPPER.m_6836_(0, stack);
            Optional<SandingRecipe> recipe = HenryRecipeTypes.SANDING.find(SANDING_WRAPPER, level);
            return recipe.map(sandingRecipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)sandingRecipe, (boolean)false)).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            Vector3f color1 = new Color(15592395).asVectorF();
            Vector3f color2 = new Color(15197371).asVectorF();
            level.m_7106_((ParticleOptions)new DustParticleOptions(color1, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)new DustParticleOptions(color2, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)new DustParticleOptions(color1, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123797_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)15197371, (int)15592395, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.0078125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123797_, 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123790_, 0.125f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (entity instanceof Zombie) {
                Zombie zombie = (Zombie)entity;
                if (!(entity instanceof Husk)) {
                    int progress = zombie.getPersistentData().m_128451_("CreateSanding");
                    if (progress < 50) {
                        if (progress % 10 == 0) {
                            level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12043_, SoundSource.NEUTRAL, 1.0f, 1.5f * (float)progress / 50.0f);
                        }
                        zombie.getPersistentData().m_128405_("CreateSanding", progress + 1);
                        return;
                    }
                    level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12044_, SoundSource.NEUTRAL, 1.25f, 0.65f);
                    Husk husk = (Husk)EntityType.f_20458_.m_20615_(level);
                    CompoundTag serializeNBT = zombie.m_20240_(new CompoundTag());
                    serializeNBT.m_128473_("UUID");
                    assert (husk != null);
                    husk.deserializeNBT(serializeNBT);
                    husk.m_146884_(zombie.m_20318_(0.0f));
                    level.m_7967_((Entity)husk);
                    zombie.m_146870_();
                }
            }
        }
    }

    public static class FreezingType
    implements FanProcessingType {
        private static final FreezingRecipe.FreezingWrapper FREEZING_WRAPPER = new FreezingRecipe.FreezingWrapper();

        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.m_6425_(pos);
            if (HenryTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_FREEZING.matches(fluidState)) {
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            return HenryTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_FREEZING.matches(blockState);
        }

        public int getPriority() {
            return 691100;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            FREEZING_WRAPPER.m_6836_(0, stack);
            Optional recipe = HenryRecipeTypes.FREEZING.find(FREEZING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            FREEZING_WRAPPER.m_6836_(0, stack);
            Optional<FreezingRecipe> recipe = HenryRecipeTypes.FREEZING.find(FREEZING_WRAPPER, level);
            return recipe.map(freezingRecipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)freezingRecipe, (boolean)false)).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            Vector3f color = new Color(14543103).asVectorF();
            level.m_7106_((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)0xEEEEFF, (int)14543103, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.0078125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_175821_, 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123759_, 0.125f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.f_46443_) {
                if (entity instanceof Skeleton) {
                    Vec3 p = entity.m_20318_(0.0f);
                    Vec3 v = p.m_82520_(0.0, 0.5, 0.0).m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)level.f_46441_, (float)1.0f).m_82542_(1.0, (double)0.2f, 1.0).m_82541_().m_82490_(1.0));
                    level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, (double)0.1f, 0.0);
                    if (level.f_46441_.m_188503_(3) == 0) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_175821_, p.f_82479_, p.f_82480_ + 0.5, p.f_82481_, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), (double)0.1f, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f));
                    }
                }
                return;
            }
            if (entity instanceof EnderMan || entity.m_6095_() == EntityType.f_20551_) {
                entity.m_6469_(level.m_269111_().m_269109_(), 8.0f);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 7, false, false));
            }
            if (entity instanceof SnowGolem) {
                SnowGolem snowgolem = (SnowGolem)entity;
                snowgolem.m_5634_(4.0f);
            }
            if (entity instanceof Stray) {
                Stray stray = (Stray)entity;
                stray.m_5634_(2.0f);
            }
            if (entity.m_6060_()) {
                entity.m_20095_();
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11914_, SoundSource.NEUTRAL, 0.7f, 1.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
            }
            if (entity instanceof Skeleton) {
                Skeleton skeleton = (Skeleton)entity;
                int progress = skeleton.getPersistentData().m_128451_("CreateFreezing");
                if (progress < 50) {
                    if (progress % 10 == 0) {
                        level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12451_, SoundSource.NEUTRAL, 1.0f, 1.5f * (float)progress / 50.0f);
                    }
                    skeleton.getPersistentData().m_128405_("CreateFreezing", progress + 1);
                    return;
                }
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_144211_, SoundSource.NEUTRAL, 1.25f, 0.65f);
                Stray stray = (Stray)EntityType.f_20481_.m_20615_(level);
                CompoundTag serializeNBT = skeleton.m_20240_(new CompoundTag());
                serializeNBT.m_128473_("UUID");
                assert (stray != null);
                stray.deserializeNBT(serializeNBT);
                stray.m_146884_(skeleton.m_20318_(0.0f));
                level.m_7967_((Entity)stray);
                skeleton.m_146870_();
            }
        }
    }

    public static class SeethingType
    implements FanProcessingType {
        private static final SeethingRecipe.SeethingWrapper SEETHING_WRAPPER = new SeethingRecipe.SeethingWrapper();

        public boolean isValidAt(Level level, BlockPos pos) {
            Block compat;
            if (HenryTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_SEETHING.matches(level.m_6425_(pos))) {
                return true;
            }
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof BlazeBurnerBlock) {
                BlazeBurnerBlock.HeatLevel heat = (BlazeBurnerBlock.HeatLevel)state.m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL);
                return heat.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING);
            }
            if (HenryMods.CREATEADDITION.isLoaded() && block == (compat = HenryMods.CREATEADDITION.getBlock("liquid_blaze_burner"))) {
                BlazeBurnerBlock.HeatLevel heat = (BlazeBurnerBlock.HeatLevel)state.m_61143_((Property)BlazeBurnerBlock.HEAT_LEVEL);
                return heat.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING);
            }
            return HenryTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_SEETHING.matches(state);
        }

        public int getPriority() {
            return 691200;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            SEETHING_WRAPPER.m_6836_(0, stack);
            Optional recipe = HenryRecipeTypes.SEETHING.find(SEETHING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            SEETHING_WRAPPER.m_6836_(0, stack);
            Optional<SeethingRecipe> recipe = HenryRecipeTypes.SEETHING.find(SEETHING_WRAPPER, level);
            return recipe.map(seethingRecipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)seethingRecipe, (boolean)false)).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            Vector3f color = new Color(1969981).asVectorF();
            level.m_7106_((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, pos.f_82479_, pos.f_82480_ + (double)0.45f, pos.f_82481_, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)6605309, (int)4158696, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123745_, 0.125f);
            }
            Vector3f colorBright = new Color(6605309).asVectorF();
            Vector3f colorDark = new Color(4158696).asVectorF();
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new DustParticleOptions(colorBright, 1.0f), 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new DustParticleOptions(colorDark, 1.0f), 0.125f);
            }
            if (random.m_188501_() < 0.020833334f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123762_, 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new CubeParticleData(192.0f, 122.0f, 85.0f, 0.075f, 10, true), 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new CubeParticleData(191.0f, 82.0f, 91.0f, 0.1f, 10, true), 0.125f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.f_46443_) {
                return;
            }
            if (entity instanceof Blaze) {
                Blaze blaze = (Blaze)entity;
                blaze.m_5634_(4.0f);
            }
            if (!entity.m_5825_()) {
                entity.m_20254_(10);
                entity.m_6469_(level.m_269111_().m_269233_(), 10.0f);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 2, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20, 1, false, false));
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 30, 0, false, false));
            }
        }
    }

    public static class WitheringType
    implements FanProcessingType {
        private static final WitheringRecipe.WitheringWrapper WITHERING_WRAPPER = new WitheringRecipe.WitheringWrapper();

        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.m_6425_(pos);
            if (HenryTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_WITHERING.matches(fluidState)) {
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            return HenryTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_WITHERING.matches(blockState);
        }

        public int getPriority() {
            return 691300;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            WITHERING_WRAPPER.m_6836_(0, stack);
            Optional recipe = HenryRecipeTypes.WITHERING.find(WITHERING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            WITHERING_WRAPPER.m_6836_(0, stack);
            Optional<WitheringRecipe> recipe = HenryRecipeTypes.WITHERING.find(WITHERING_WRAPPER, level);
            return recipe.map(witheringRecipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)witheringRecipe, (boolean)false)).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            Vector3f color = new Color(1969981).asVectorF();
            level.m_7106_((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, pos.f_82479_, pos.f_82480_ + (double)0.45f, pos.f_82481_, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)1575984, (int)1969981, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123746_, 0.125f);
            }
            Vector3f colorBright = new Color(1575984).asVectorF();
            Vector3f colorDark = new Color(1969981).asVectorF();
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new DustParticleOptions(colorBright, 1.0f), 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new DustParticleOptions(colorDark, 1.0f), 0.125f);
            }
            if (random.m_188501_() < 0.020833334f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123783_, 0.125f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.f_46443_) {
                if (entity instanceof Skeleton) {
                    Vec3 p = entity.m_20318_(0.0f);
                    Vec3 v = p.m_82520_(0.0, 0.5, 0.0).m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)level.f_46441_, (float)1.0f).m_82542_(1.0, (double)0.2f, 1.0).m_82541_().m_82490_(1.0));
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123783_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, (double)0.1f, 0.0);
                    if (level.f_46441_.m_188503_(3) == 0) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123783_, p.f_82479_, p.f_82480_ + 0.5, p.f_82481_, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), (double)0.1f, (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f));
                    }
                }
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 5, 1, false, false));
            }
            if (entity instanceof WitherBoss) {
                WitherBoss witherBoss = (WitherBoss)entity;
                witherBoss.m_5634_(4.0f);
            }
            if (entity instanceof WitherSkeleton) {
                WitherSkeleton witherSkeleton = (WitherSkeleton)entity;
                witherSkeleton.m_5634_(2.0f);
            }
            if (entity instanceof Skeleton) {
                Skeleton skeleton = (Skeleton)entity;
                int progress = skeleton.getPersistentData().m_128451_("CreateWithering");
                if (progress < 50) {
                    if (progress % 10 == 0) {
                        level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12559_, SoundSource.NEUTRAL, 1.0f, 1.5f * (float)progress / 50.0f);
                    }
                    skeleton.getPersistentData().m_128405_("CreateWithering", progress + 1);
                    return;
                }
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12562_, SoundSource.NEUTRAL, 1.25f, 0.65f);
                WitherSkeleton witherSkeleton = (WitherSkeleton)EntityType.f_20497_.m_20615_(level);
                CompoundTag serializeNBT = skeleton.m_20240_(new CompoundTag());
                serializeNBT.m_128473_("UUID");
                assert (witherSkeleton != null);
                witherSkeleton.deserializeNBT(serializeNBT);
                witherSkeleton.m_146884_(skeleton.m_20318_(0.0f));
                level.m_7967_((Entity)witherSkeleton);
                skeleton.m_146870_();
            }
        }
    }

    public static class DragonBreathingType
    implements FanProcessingType {
        private static final DragonBreathingRecipe.dragonBreathingWrapper DRAGON_BREATHING_WRAPPER = new DragonBreathingRecipe.dragonBreathingWrapper();

        public boolean isValidAt(Level level, BlockPos pos) {
            FluidState fluidState = level.m_6425_(pos);
            if (HenryTags.AllFluidTags.FAN_PROCESSING_CATALYSTS_DRAGON_BREATHING.matches(fluidState)) {
                return true;
            }
            BlockState blockState = level.m_8055_(pos);
            return HenryTags.AllBlockTags.FAN_PROCESSING_CATALYSTS_DRAGON_BREATHING.matches(blockState);
        }

        public int getPriority() {
            return 691400;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            DRAGON_BREATHING_WRAPPER.m_6836_(0, stack);
            Optional recipe = HenryRecipeTypes.DRAGON_BREATHING.find(DRAGON_BREATHING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            DRAGON_BREATHING_WRAPPER.m_6836_(0, stack);
            Optional<DragonBreathingRecipe> recipe = HenryRecipeTypes.DRAGON_BREATHING.find(DRAGON_BREATHING_WRAPPER, level);
            return recipe.map(dragonBreathingRecipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)dragonBreathingRecipe, (boolean)false)).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123799_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)13856729, (int)12721141, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.0078125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123799_, 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123771_, 0.125f);
            }
            float r = 0.2f;
            float g = 0.08f;
            float b = 0.3f;
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new CubeParticleData(r, g, b, 0.075f, 12, false), 0.125f);
            }
            if (random.m_188501_() < 0.03125f) {
                particleAccess.spawnExtraParticle((ParticleOptions)new CubeParticleData(r, g, b, 0.1f, 14, false), 0.125f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (entity instanceof Silverfish) {
                Silverfish silverfish = (Silverfish)entity;
                int progress = silverfish.getPersistentData().m_128451_("CreateBreathing");
                if (progress < 50) {
                    if (progress % 10 == 0) {
                        level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11853_, SoundSource.NEUTRAL, 0.5f, 1.5f * (float)progress / 50.0f);
                    }
                    silverfish.getPersistentData().m_128405_("CreateBreathing", progress + 1);
                    return;
                }
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11850_, SoundSource.NEUTRAL, 1.25f, 0.65f);
                Endermite endermite = (Endermite)EntityType.f_20567_.m_20615_(level);
                CompoundTag serializeNBT = silverfish.m_20240_(new CompoundTag());
                serializeNBT.m_128473_("UUID");
                assert (endermite != null);
                endermite.deserializeNBT(serializeNBT);
                endermite.m_146884_(silverfish.m_20318_(0.0f));
                level.m_7967_((Entity)endermite);
                silverfish.m_146870_();
            } else if (entity instanceof WitherSkeleton) {
                WitherSkeleton witherSkeleton = (WitherSkeleton)entity;
                int progress = witherSkeleton.getPersistentData().m_128451_("CreateBreathing");
                if (progress < 50) {
                    if (progress % 10 == 0) {
                        level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11850_, SoundSource.NEUTRAL, 1.0f, 1.5f * (float)progress / 50.0f);
                    }
                    witherSkeleton.getPersistentData().m_128405_("CreateBreathing", progress + 1);
                    return;
                }
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11851_, SoundSource.NEUTRAL, 1.0f, 0.65f);
                EnderMan enderMan = (EnderMan)EntityType.f_20566_.m_20615_(level);
                CompoundTag serializeNBT = witherSkeleton.m_20240_(new CompoundTag());
                serializeNBT.m_128473_("UUID");
                assert (enderMan != null);
                enderMan.deserializeNBT(serializeNBT);
                enderMan.m_146884_(witherSkeleton.m_20318_(0.0f));
                level.m_7967_((Entity)enderMan);
                witherSkeleton.m_146870_();
            } else if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!(entity instanceof EnderMan || entity instanceof Endermite || entity instanceof EnderDragon)) {
                    double x = livingEntity.m_20185_();
                    double y = livingEntity.m_20186_();
                    double z = livingEntity.m_20189_();
                    RandomSource rand = level.f_46441_;
                    double dx = rand.m_188500_() * 5.0 - 5.0;
                    double dz = rand.m_188500_() * 5.0 - 5.0;
                    double dy = rand.m_188500_() * 2.0 - 2.0;
                    double newX = x + dx;
                    double newY = Math.max(0.0, y + dy);
                    double newZ = z + dz;
                    livingEntity.m_6021_(newX, newY, newZ);
                    level.m_6263_(null, newX, newY, newZ, SoundEvents.f_11852_, SoundSource.NEUTRAL, 1.0f, 1.0f + (float)(rand.m_188583_() * 0.05));
                    for (int i = 0; i < 10; ++i) {
                        double px = newX + (rand.m_188500_() - 0.5) * 2.0;
                        double py = newY + rand.m_188500_() * 2.0;
                        double pz = newZ + (rand.m_188500_() - 0.5) * 2.0;
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, px, py, pz, (rand.m_188500_() - 0.5) * 2.0, (rand.m_188500_() - 0.5) * 2.0, (rand.m_188500_() - 0.5) * 2.0);
                    }
                }
            }
        }
    }
}

