/*
 * Decompiled with CFR 0.152.
 */
package com.chocoboy.create_henry.registry;

import com.chocoboy.create_henry.HenryCreate;
import com.chocoboy.create_henry.content.jei.FanDragonBreathingCategory;
import com.chocoboy.create_henry.content.jei.FanFreezingCategory;
import com.chocoboy.create_henry.content.jei.FanSandingCategory;
import com.chocoboy.create_henry.content.jei.FanSeethingCategory;
import com.chocoboy.create_henry.content.jei.FanWitheringCategory;
import com.chocoboy.create_henry.content.jei.HProcessingViaFanCategory;
import com.chocoboy.create_henry.content.recipes.DragonBreathingRecipe;
import com.chocoboy.create_henry.content.recipes.FreezingRecipe;
import com.chocoboy.create_henry.content.recipes.SandingRecipe;
import com.chocoboy.create_henry.content.recipes.SeethingRecipe;
import com.chocoboy.create_henry.content.recipes.WitheringRecipe;
import com.chocoboy.create_henry.infrastructure.config.HRecipes;
import com.chocoboy.create_henry.infrastructure.config.HenryConfigs;
import com.chocoboy.create_henry.registry.HenryBlocks;
import com.chocoboy.create_henry.registry.HenryRecipeTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.BlueprintTransferHandler;
import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class HenryJEI
implements IModPlugin {
    private static final ResourceLocation MOD_ID = new ResourceLocation("create_henry", "jei_plugin");
    private static final List<CreateRecipeCategory<?>> allCategories = new ArrayList();
    private IIngredientManager ingredientManager;

    @Nonnull
    public ResourceLocation getPluginUid() {
        return MOD_ID;
    }

    private void loadCategories() {
        allCategories.clear();
        CreateRecipeCategory<SandingRecipe> sanding = this.builder(SandingRecipe.class).addTypedRecipes(HenryRecipeTypes.SANDING).catalystStack(HProcessingViaFanCategory.getFan("fan_sanding")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_41830_).emptyBackground(178, 72).build("fan_sanding", (CreateRecipeCategory.Factory<SandingRecipe>)((CreateRecipeCategory.Factory)FanSandingCategory::new));
        CreateRecipeCategory<FreezingRecipe> freezing = this.builder(FreezingRecipe.class).addTypedRecipes(HenryRecipeTypes.FREEZING).catalystStack(HProcessingViaFanCategory.getFan("fan_freezing")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_151055_).emptyBackground(178, 72).build("fan_freezing", (CreateRecipeCategory.Factory<FreezingRecipe>)((CreateRecipeCategory.Factory)FanFreezingCategory::new));
        CreateRecipeCategory<SeethingRecipe> seething = this.builder(SeethingRecipe.class).addTypedRecipes(HenryRecipeTypes.SEETHING).catalystStack(HProcessingViaFanCategory.getFan("fan_seething")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)AllItems.BLAZE_CAKE.get()).emptyBackground(178, 72).build("fan_seething", (CreateRecipeCategory.Factory<SeethingRecipe>)((CreateRecipeCategory.Factory)FanSeethingCategory::new));
        CreateRecipeCategory<WitheringRecipe> withering = this.builder(WitheringRecipe.class).addTypedRecipes(HenryRecipeTypes.WITHERING).catalystStack(HProcessingViaFanCategory.getFan("fan_withering")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_41951_).emptyBackground(178, 72).build("fan_withering", (CreateRecipeCategory.Factory<WitheringRecipe>)((CreateRecipeCategory.Factory)FanWitheringCategory::new));
        CreateRecipeCategory<DragonBreathingRecipe> dragon_breathing = this.builder(DragonBreathingRecipe.class).addTypedRecipes(HenryRecipeTypes.DRAGON_BREATHING).catalystStack(HProcessingViaFanCategory.getFan("fan_dragon_breathing")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_42683_).emptyBackground(178, 72).build("fan_dragon_breathing", (CreateRecipeCategory.Factory<DragonBreathingRecipe>)((CreateRecipeCategory.Factory)FanDragonBreathingCategory::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        allCategories.forEach(c -> c.registerRecipes(registration));
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])allCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        allCategories.forEach(c -> c.registerCatalysts(registration));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create", "fan_washing")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)HenryBlocks.INDUSTRIAL_FAN.get()), new RecipeType[]{type}));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create", "fan_smoking")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)HenryBlocks.INDUSTRIAL_FAN.get()), new RecipeType[]{type}));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create", "fan_blasting")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)HenryBlocks.INDUSTRIAL_FAN.get()), new RecipeType[]{type}));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create", "fan_haunting")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)HenryBlocks.INDUSTRIAL_FAN.get()), new RecipeType[]{type}));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create_henry", "fan_sanding")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)AllBlocks.ENCASED_FAN.get()), new RecipeType[]{type}));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create_henry", "fan_seething")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)AllBlocks.ENCASED_FAN.get()), new RecipeType[]{type}));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create_henry", "fan_freezing")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)AllBlocks.ENCASED_FAN.get()), new RecipeType[]{type}));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create_henry", "fan_withering")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)AllBlocks.ENCASED_FAN.get()), new RecipeType[]{type}));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create_henry", "fan_dragon_breathing")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)AllBlocks.ENCASED_FAN.get()), new RecipeType[]{type}));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BlueprintTransferHandler(), RecipeTypes.CRAFTING);
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    public static void consumeAllRecipes(Consumer<Recipe<?>> consumer) {
        Objects.requireNonNull(Minecraft.m_91087_().m_91403_()).m_105141_().m_44051_().forEach(consumer);
    }

    private static class CategoryBuilder<T extends Recipe<?>> {
        private final Class<? extends T> recipeClass;
        private Predicate<HRecipes> predicate = hRecipes -> true;
        private IDrawable background;
        private IDrawable icon;
        private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        private String formatNiceName(String raw) {
            if (raw.startsWith("fan_")) {
                raw = raw.substring(4);
            }
            String[] parts = raw.split("_");
            StringBuilder b = new StringBuilder();
            for (String p : parts) {
                if (p.isEmpty()) continue;
                b.append(Character.toUpperCase(p.charAt(0))).append(p.substring(1)).append(" ");
            }
            return "Bulk " + b.toString().trim();
        }

        public CategoryBuilder<T> enableIf(Predicate<HRecipes> predicate) {
            this.predicate = predicate;
            return this;
        }

        public CategoryBuilder<T> enableWhen(Function<HRecipes, ConfigBase.ConfigBool> configValue) {
            this.predicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((HRecipes)((Object)c))).get();
            return this;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> addRecipes(Supplier<Collection<? extends T>> collection) {
            return this.addRecipeListConsumer(recipes -> recipes.addAll((Collection)collection.get()));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> HenryJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> HenryJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add((Recipe)converter.apply((Recipe<?>)recipe));
                }
            }));
        }

        public CategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
            return this.addTypedRecipes(() -> ((IRecipeTypeInfo)recipeTypeEntry).getType());
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipes::add, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> recipes.add((Recipe)converter.apply((Recipe<?>)recipe)), (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesIf(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesExcluding(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> excluded) {
            return this.addRecipeListConsumer(recipes -> {
                List<Recipe<?>> excludedRecipes = CategoryBuilder.DDgetTypedRecipes((net.minecraft.world.item.crafting.RecipeType)excluded.get());
                CreateJEI.consumeTypedRecipes(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CategoryBuilder.DDdoInputsMatch(recipe, excludedRecipe)) continue;
                        return;
                    }
                    recipes.add(recipe);
                }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
            });
        }

        public CategoryBuilder<T> removeRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> {
                List<Recipe<?>> excludedRecipes = CategoryBuilder.DDgetTypedRecipes((net.minecraft.world.item.crafting.RecipeType)recipeType.get());
                recipes.removeIf(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CategoryBuilder.DDdoInputsMatch(recipe, excludedRecipe)) continue;
                        return true;
                    }
                    return false;
                });
            });
        }

        public static List<Recipe<?>> DDgetTypedRecipes(net.minecraft.world.item.crafting.RecipeType<?> type) {
            ArrayList recipes = new ArrayList();
            CreateJEI.consumeTypedRecipes(recipes::add, type);
            return recipes;
        }

        public static List<Recipe<?>> DDgetTypedRecipesExcluding(net.minecraft.world.item.crafting.RecipeType<?> type, Predicate<Recipe<?>> exclusionPred) {
            List<Recipe<?>> recipes = CategoryBuilder.DDgetTypedRecipes(type);
            recipes.removeIf(exclusionPred);
            return recipes;
        }

        public static boolean DDdoInputsMatch(Recipe<?> recipe1, Recipe<?> recipe2) {
            if (recipe1.m_7527_().isEmpty() || recipe2.m_7527_().isEmpty()) {
                return false;
            }
            ItemStack[] matchingStacks = ((Ingredient)recipe1.m_7527_().get(0)).m_43908_();
            if (matchingStacks.length == 0) {
                return false;
            }
            return ((Ingredient)recipe2.m_7527_().get(0)).test(matchingStacks[0]);
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_()));
        }

        public CategoryBuilder<T> icon(IDrawable icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon((IDrawable)new ItemIcon(() -> new ItemStack(item)));
            return this;
        }

        public CategoryBuilder<T> doubleItemIcon(ItemLike item1, ItemLike item2) {
            this.icon((IDrawable)new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2)));
            return this;
        }

        public CategoryBuilder<T> background(IDrawable background) {
            this.background = background;
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background((IDrawable)new EmptyBackground(width, height));
            return this;
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = this.predicate.test(HenryConfigs.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            } : Collections::emptyList;
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(new RecipeType(HenryCreate.asResource(name), this.recipeClass), (Component)Component.m_237113_((String)this.formatNiceName(name)), this.background, this.icon, recipesSupplier, this.catalysts);
            CreateRecipeCategory category = factory.create(info);
            allCategories.add(category);
            return category;
        }
    }
}

