/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatartifacts.client;

import artifacts.client.item.RendererUtil;
import artifacts.client.item.model.ArmsModel;
import artifacts.client.item.model.BeltModel;
import artifacts.client.item.model.HeadModel;
import artifacts.client.item.model.LegsModel;
import artifacts.client.item.model.NecklaceModel;
import artifacts.client.item.renderer.GenericArtifactRenderer;
import artifacts.client.item.renderer.GloveArtifactRenderer;
import artifacts.item.wearable.WearableArtifactItem;
import artifacts.platform.PlatformServices;
import java.util.function.Supplier;
import net.fixerlink.compatartifacts.client.ArtifactCompatLayers;
import net.fixerlink.compatartifacts.client.CompatBeltArtifactRenderer;
import net.fixerlink.compatartifacts.compats.alexscaves.AlexCavesModItems;
import net.fixerlink.compatartifacts.compats.ars_nouveau.ArsModItems;
import net.fixerlink.compatartifacts.compats.botania.BotaniaModItems;
import net.fixerlink.compatartifacts.compats.cataclysm.CataclysmModItems;
import net.fixerlink.compatartifacts.compats.ecologics.EcologicsModItems;
import net.fixerlink.compatartifacts.compats.immersiveengineering.EnginModItems;
import net.fixerlink.compatartifacts.compats.irons_spellbooks.IronModItems;
import net.fixerlink.compatartifacts.compats.mowziesmobs.MobsModItems;
import net.fixerlink.compatartifacts.compats.toughasnails.NailsModItems;
import net.fixerlink.compatartifacts.compats.twilightforest.ForestModItems;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;

public final class ArtifactCompatRenderers {
    private ArtifactCompatRenderers() {
    }

    public static void register() {
        if (ModList.get().isLoaded("alexscaves")) {
            ArtifactCompatRenderers.registerAntiNuclearNecklace();
            ArtifactCompatRenderers.registerAmuletofDrop();
            ArtifactCompatRenderers.registerCharmofMagnet();
            ArtifactCompatRenderers.registerPearlPendant();
            ArtifactCompatRenderers.registerLegendMagicConch();
            ArtifactCompatRenderers.registerChocolateClaws();
            ArtifactCompatRenderers.registerPolymerRelic();
        }
        if (ModList.get().isLoaded("ars_nouveau")) {
            ArtifactCompatRenderers.registerRelicofManaBoost();
            ArtifactCompatRenderers.registerRelicofManaRegen();
            ArtifactCompatRenderers.registerBeltGravity();
        }
        if (ModList.get().isLoaded("botania")) {
            ArtifactCompatRenderers.registerManaGoggles();
        }
        if (ModList.get().isLoaded("cataclysm")) {
            ArtifactCompatRenderers.registerAncientMetalPendant();
            ArtifactCompatRenderers.registerMetalClaws();
        }
        if (ModList.get().isLoaded("create")) {
            // empty if block
        }
        if (ModList.get().isLoaded("ecologics")) {
            ArtifactCompatRenderers.registerSandinaBottle();
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            // empty if block
        }
        if (ModList.get().isLoaded("iceandfire")) {
            // empty if block
        }
        if (ModList.get().isLoaded("immersiveengineering")) {
            ArtifactCompatRenderers.registerSteelShoes();
            ArtifactCompatRenderers.registerUraniumPlateShoes();
        }
        if (ModList.get().isLoaded("irons_spellbooks")) {
            ArtifactCompatRenderers.registerBloodVialNecklace();
            ArtifactCompatRenderers.registerLightningPendant();
            ArtifactCompatRenderers.registerPermafrostPendant();
            ArtifactCompatRenderers.registerFrozenBelt();
            ArtifactCompatRenderers.registerArcaneHat();
            ArtifactCompatRenderers.registerDivinePearlRing();
        }
        if (ModList.get().isLoaded("mowziesmobs")) {
            ArtifactCompatRenderers.registerNagaFangPendant();
            ArtifactCompatRenderers.registerSunsNecklace();
            ArtifactCompatRenderers.registerFrostBottle();
            ArtifactCompatRenderers.registerLuminousJellyBottle();
        }
        if (ModList.get().isLoaded("quark")) {
            // empty if block
        }
        if (ModList.get().isLoaded("tconstruct")) {
            // empty if block
        }
        if (ModList.get().isLoaded("toughasnails")) {
            ArtifactCompatRenderers.registerFireNecklace();
            ArtifactCompatRenderers.registerIceNecklace();
            ArtifactCompatRenderers.registerWaterNecklace();
        }
        if (ModList.get().isLoaded("twilightforest")) {
            ArtifactCompatRenderers.registerCharmofKnightMetal();
            ArtifactCompatRenderers.registerFieryClaws();
            ArtifactCompatRenderers.registerSteeleafClaws();
            ArtifactCompatRenderers.registerCloudinaLargeBottle();
            ArtifactCompatRenderers.registerKnightmetalTiara();
        }
        if (ModList.get().isLoaded("undergarden")) {
            // empty if block
        }
    }

    private static ResourceLocation wearable(String name) {
        return new ResourceLocation("compatartifacts", "textures/entity/wearable/" + name + ".png");
    }

    private static void registerNecklace(WearableArtifactItem item, String textureName, ModelLayerLocation layer) {
        PlatformServices.platformHelper.registerArtifactRenderer(item, () -> new GenericArtifactRenderer(ArtifactCompatRenderers.wearable(textureName), (HumanoidModel)new NecklaceModel(RendererUtil.bakeLayer((ModelLayerLocation)layer))));
    }

    private static void registerGloveClaws(WearableArtifactItem item, String textureName) {
        ResourceLocation tex = ArtifactCompatRenderers.wearable(textureName);
        PlatformServices.platformHelper.registerArtifactRenderer(item, () -> new GloveArtifactRenderer(tex, tex, ArmsModel::createClawsModel));
    }

    private static void registerBelt(WearableArtifactItem item, String textureName, Supplier<BeltModel> modelFactory) {
        PlatformServices.platformHelper.registerArtifactRenderer(item, () -> new CompatBeltArtifactRenderer(ArtifactCompatRenderers.wearable(textureName), (BeltModel)modelFactory.get()));
    }

    private static void registerBoots(WearableArtifactItem item, String textureName, ModelLayerLocation layer) {
        PlatformServices.platformHelper.registerArtifactRenderer(item, () -> new GenericArtifactRenderer(ArtifactCompatRenderers.wearable(textureName), (HumanoidModel)new LegsModel(RendererUtil.bakeLayer((ModelLayerLocation)layer))));
    }

    private static void registerHat(WearableArtifactItem item, String textureName, ModelLayerLocation layer) {
        PlatformServices.platformHelper.registerArtifactRenderer(item, () -> new GenericArtifactRenderer(ArtifactCompatRenderers.wearable(textureName), (HumanoidModel)new HeadModel(RendererUtil.bakeLayer((ModelLayerLocation)layer))));
    }

    private static void registerGoggles(WearableArtifactItem item, String textureName, ModelLayerLocation layer) {
        PlatformServices.platformHelper.registerArtifactRenderer(item, () -> new GenericArtifactRenderer(ArtifactCompatRenderers.wearable(textureName), (HumanoidModel)new HeadModel(RendererUtil.bakeLayer((ModelLayerLocation)layer), RenderType::m_110473_)));
    }

    private static void registerRingStyleSingleTex(WearableArtifactItem item, String baseTextureName) {
        ResourceLocation tex = ArtifactCompatRenderers.wearable(baseTextureName);
        PlatformServices.platformHelper.registerArtifactRenderer(item, () -> new GloveArtifactRenderer(tex, tex, ArmsModel::createOnionRingModel));
    }

    private static void registerAntiNuclearNecklace() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)AlexCavesModItems.ANTI_NUCLEAR_NECKLACE.get(), "anti_nuclear_necklace", ArtifactCompatLayers.ANTI_NUCLEAR_NECKLACE);
    }

    private static void registerAmuletofDrop() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)CataclysmModItems.AMULET_OF_DROP.get(), "amulet_of_drop", ArtifactCompatLayers.AMULET_OF_DROP);
    }

    private static void registerAncientMetalPendant() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)CataclysmModItems.ANCIENT_METAL_PENDANT.get(), "ancient_metal_pendant", ArtifactCompatLayers.ANCIENT_METAL_PENDANT);
    }

    private static void registerBloodVialNecklace() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)IronModItems.BLOOD_VIAL_NECKLACE.get(), "blood_vial_necklace", ArtifactCompatLayers.BLOOD_VIAL_NECKLACE);
    }

    private static void registerCharmofKnightMetal() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)ForestModItems.CHARM_OF_KNIGHTMETAL.get(), "charm_of_knightmetal", ArtifactCompatLayers.CHARM_OF_KNIGHTMETAL);
    }

    private static void registerCharmofMagnet() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)AlexCavesModItems.CHARM_OF_MAGNET.get(), "charm_of_magnet", ArtifactCompatLayers.CHARM_OF_MAGNET);
    }

    private static void registerFireNecklace() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)NailsModItems.FIRE_NECKLACE.get(), "fire_necklace", ArtifactCompatLayers.FIRE_NECKLACE);
    }

    private static void registerIceNecklace() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)NailsModItems.ICE_NECKLACE.get(), "ice_necklace", ArtifactCompatLayers.ICE_NECKLACE);
    }

    private static void registerLightningPendant() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)IronModItems.LIGHTNING_PENDANT.get(), "lightning_pendant", ArtifactCompatLayers.LIGHTNING_PENDANT);
    }

    private static void registerNagaFangPendant() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)MobsModItems.NAGA_FANG_PENDANT.get(), "naga_fang_pendant", ArtifactCompatLayers.NAGA_FANG_PENDANT);
    }

    private static void registerPearlPendant() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)AlexCavesModItems.PEARL_PENDANT.get(), "pearl_pendant", ArtifactCompatLayers.PEARL_PENDANT);
    }

    private static void registerPermafrostPendant() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)IronModItems.PERMAFROST_PENDANT.get(), "permafrost_pendant", ArtifactCompatLayers.PERMAFROST_PENDANT);
    }

    private static void registerRelicofManaBoost() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)ArsModItems.RELIC_OF_MANA_BOOST.get(), "relic_of_mana_boost", ArtifactCompatLayers.RELIC_OF_MANA_BOOST);
    }

    private static void registerRelicofManaRegen() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)ArsModItems.RELIC_OF_MANA_REGEN.get(), "relic_of_mana_regen", ArtifactCompatLayers.RELIC_OF_MANA_REGEN);
    }

    private static void registerSunsNecklace() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)MobsModItems.SUNS_NECKLACE.get(), "suns_necklace", ArtifactCompatLayers.SUNS_NECKLACE);
    }

    private static void registerWaterNecklace() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)NailsModItems.WATER_NECKLACE.get(), "water_necklace", ArtifactCompatLayers.WATER_NECKLACE);
    }

    private static void registerLegendMagicConch() {
        ArtifactCompatRenderers.registerNecklace((WearableArtifactItem)AlexCavesModItems.LEGEND_MAGIC_CONCH.get(), "legend_magic_conch", ArtifactCompatLayers.LEGEND_MAGIC_CONCH);
    }

    private static void registerChocolateClaws() {
        ArtifactCompatRenderers.registerGloveClaws((WearableArtifactItem)AlexCavesModItems.CHOCOLATE_CLAWS.get(), "chocolate_claws");
    }

    private static void registerFieryClaws() {
        ArtifactCompatRenderers.registerGloveClaws((WearableArtifactItem)ForestModItems.FIERY_CLAWS.get(), "fiery_claws");
    }

    private static void registerMetalClaws() {
        ArtifactCompatRenderers.registerGloveClaws((WearableArtifactItem)CataclysmModItems.METAL_CLAWS.get(), "metal_claws");
    }

    private static void registerSteeleafClaws() {
        ArtifactCompatRenderers.registerGloveClaws((WearableArtifactItem)ForestModItems.STEELEAF_CLAWS.get(), "steeleaf_claws");
    }

    private static void registerBeltGravity() {
        ArtifactCompatRenderers.registerBelt((WearableArtifactItem)ArsModItems.BELT_GRAVITY.get(), "belt_gravity", BeltModel::createCloudInABottleModel);
    }

    private static void registerCloudinaLargeBottle() {
        ArtifactCompatRenderers.registerBelt((WearableArtifactItem)ForestModItems.CLOUD_LARGE_BOTTLE.get(), "cloud_in_a_large_bottle", BeltModel::createAntidoteVesselModel);
    }

    private static void registerFrostBottle() {
        ArtifactCompatRenderers.registerBelt((WearableArtifactItem)MobsModItems.FROST_BOTTLE.get(), "frost_bottle", BeltModel::createCloudInABottleModel);
    }

    private static void registerFrozenBelt() {
        ArtifactCompatRenderers.registerBelt((WearableArtifactItem)IronModItems.FROZEN_BELT.get(), "frozen_belt", BeltModel::createCloudInABottleModel);
    }

    private static void registerLuminousJellyBottle() {
        ArtifactCompatRenderers.registerBelt((WearableArtifactItem)MobsModItems.LUMINOUS_JELLY_BOTTLE.get(), "luminous_jelly_bottle", BeltModel::createCloudInABottleModel);
    }

    private static void registerSandinaBottle() {
        ArtifactCompatRenderers.registerBelt((WearableArtifactItem)EcologicsModItems.SAND_IN_A_BOTTLE.get(), "sand_in_a_bottle", BeltModel::createCloudInABottleModel);
    }

    private static void registerPolymerRelic() {
        ArtifactCompatRenderers.registerBelt((WearableArtifactItem)AlexCavesModItems.POLYMER_RELIC.get(), "polymer_relic", BeltModel::createCloudInABottleModel);
    }

    private static void registerSteelShoes() {
        ArtifactCompatRenderers.registerBoots((WearableArtifactItem)EnginModItems.STEEL_SHOES.get(), "steel_shoes", ArtifactCompatLayers.STEEL_SHOES);
    }

    private static void registerUraniumPlateShoes() {
        ArtifactCompatRenderers.registerBoots((WearableArtifactItem)EnginModItems.URANIUM_PLATE_SHOES.get(), "uranium_plate_shoes", ArtifactCompatLayers.URANIUM_PLATE_SHOES);
    }

    private static void registerArcaneHat() {
        ArtifactCompatRenderers.registerHat((WearableArtifactItem)IronModItems.ARCANE_HAT.get(), "arcane_hat", ArtifactCompatLayers.ARCANE_HAT);
    }

    private static void registerKnightmetalTiara() {
        ArtifactCompatRenderers.registerHat((WearableArtifactItem)ForestModItems.KNIGHTMETAL_TIARA.get(), "knightmetal_tiara", ArtifactCompatLayers.KNIGHTMETAL_TIARA);
    }

    private static void registerManaGoggles() {
        ArtifactCompatRenderers.registerGoggles((WearableArtifactItem)BotaniaModItems.MANA_GOGGLES.get(), "mana_goggles", ArtifactCompatLayers.MANA_GOGGLES);
    }

    private static void registerDivinePearlRing() {
        ArtifactCompatRenderers.registerRingStyleSingleTex((WearableArtifactItem)IronModItems.DIVINE_PEARL_RING.get(), "divine_pearl_ring");
    }
}

