/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatartifacts.compats.alexscaves.item;

import artifacts.item.ArtifactItem;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AmberTotem
extends ArtifactItem {
    private final Supplier<Integer> cooldown;
    private final Supplier<Boolean> isEnabled;

    public AmberTotem(Supplier<Integer> cooldown, Supplier<Boolean> isEnabled) {
        super(new Item.Properties());
        this.cooldown = cooldown;
        this.isEnabled = isEnabled;
        EntityEvent.LIVING_DEATH.register(this::onLivingDeath);
    }

    public boolean isCosmetic() {
        return this.isEnabled.get() == false;
    }

    protected String getTooltipItemName() {
        return "amber_totem";
    }

    private EventResult onLivingDeath(LivingEntity entity, DamageSource source) {
        if (!this.isEnabled.get().booleanValue()) {
            return EventResult.pass();
        }
        if (!(entity instanceof ServerPlayer)) {
            return EventResult.pass();
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (player.m_9236_().m_5776_()) {
            return EventResult.pass();
        }
        if (this.isOnCooldown((LivingEntity)player)) {
            return EventResult.pass();
        }
        ItemStack totem = this.findTotemInHands(player);
        if (totem.m_41619_()) {
            return EventResult.pass();
        }
        player.m_21153_(1.0f);
        player.m_21219_();
        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 1));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 200, 0));
        player.m_9236_().m_7605_((Entity)player, (byte)35);
        this.addCooldown((LivingEntity)player, this.cooldown.get());
        return EventResult.interruptFalse();
    }

    private ItemStack findTotemInHands(ServerPlayer player) {
        if (player.m_21205_().m_41720_() == this) {
            return player.m_21205_();
        }
        if (player.m_21206_().m_41720_() == this) {
            return player.m_21206_();
        }
        return ItemStack.f_41583_;
    }
}

