/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatartifacts.compats.ars_nouveau.item;

import artifacts.item.wearable.WearableArtifactItem;
import com.hollingsworth.arsnouveau.common.entity.EntityChimeraProjectile;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class InfinityWildenSpike
extends WearableArtifactItem {
    private static final Random RANDOM = new Random();
    private static final int COOLDOWN_TICKS = 1200;

    public InfinityWildenSpike() {
        EntityEvent.LIVING_HURT.register(this::onLivingHurt);
    }

    protected String getTooltipItemName() {
        return "infinity_wilden_spike";
    }

    protected boolean hasNonCosmeticEffects() {
        return true;
    }

    private EventResult onLivingHurt(LivingEntity entity, DamageSource source, float amount) {
        if (!(entity instanceof Player)) {
            return EventResult.pass();
        }
        Player player = (Player)entity;
        if (entity.m_9236_().m_5776_()) {
            return EventResult.pass();
        }
        if (!this.isEquippedBy(entity)) {
            return EventResult.pass();
        }
        if (amount < 1.0f) {
            return EventResult.pass();
        }
        if (this.isOnCooldown(entity)) {
            return EventResult.pass();
        }
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawnChimeraSpikesAroundPlayer(serverLevel, player);
            this.addCooldown(entity, 1200);
        }
        return EventResult.pass();
    }

    private void spawnChimeraSpikesAroundPlayer(ServerLevel level, Player player) {
        for (int i = 0; i < 8; ++i) {
            Vec3 direction = new Vec3(RANDOM.nextDouble() * 2.0 - 1.0, RANDOM.nextDouble() * 0.5, RANDOM.nextDouble() * 2.0 - 1.0).m_82541_();
            EntityChimeraProjectile chimeraSpike = new EntityChimeraProjectile((LivingEntity)player, (Level)level);
            chimeraSpike.m_6034_(player.m_20185_(), player.m_20186_() + 1.5, player.m_20189_());
            chimeraSpike.m_20256_(direction.m_82490_(1.5));
            level.m_7967_((Entity)chimeraSpike);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 10, 0.1, 0.1, 0.1, 0.01);
        }
    }
}

