/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatartifacts.compats.botania.item;

import artifacts.item.ArtifactItem;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.mana.ManaPool;

public class InfinityManaBottle
extends ArtifactItem {
    private static final int COOLDOWN_TICKS = 36000;
    private static final int MANA_POOL_RADIUS = 3;
    private final Random random = new Random();

    public InfinityManaBottle() {
        super(new Item.Properties().m_41487_(1).m_41489_(new FoodProperties.Builder().m_38765_().m_38767_()));
    }

    public boolean isCosmetic() {
        return false;
    }

    protected String getTooltipItemName() {
        return "infinity_mana_bottle";
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isOnCooldown((LivingEntity)player)) {
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)"item.botaniaartifacts.infinity_mana_bottle.cooldown").m_130940_(ChatFormatting.RED), true);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        if (this.isOnCooldown((LivingEntity)player)) {
            return stack;
        }
        entity.m_5584_(level, stack.m_41777_());
        this.addCooldown(entity, 36000);
        if (!level.f_46443_) {
            this.restoreManaToNearbyPools(player, level);
        }
        return stack;
    }

    private void restoreManaToNearbyPools(Player player, Level world) {
        AABB searchArea = new AABB(player.m_20183_()).m_82400_(3.0);
        for (int x = (int)searchArea.f_82288_; x <= (int)searchArea.f_82291_; ++x) {
            for (int y = (int)searchArea.f_82289_; y <= (int)searchArea.f_82292_; ++y) {
                for (int z = (int)searchArea.f_82290_; z <= (int)searchArea.f_82293_; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockEntity blockEntity = world.m_7702_(pos);
                    if (!(blockEntity instanceof ManaPool)) continue;
                    ManaPool pool = (ManaPool)blockEntity;
                    int maxMana = pool.getMaxMana();
                    int minManaRestore = maxMana / 16;
                    int maxManaRestore = maxMana / 8;
                    int manaToRestore = this.random.nextInt(maxManaRestore - minManaRestore + 1) + minManaRestore;
                    pool.receiveMana(manaToRestore);
                    player.m_5661_((Component)Component.m_237110_((String)"message.botaniaartifacts.mana_restored_to_pool", (Object[])new Object[]{manaToRestore}), true);
                }
            }
        }
    }
}

