/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatartifacts.compats.cataclysm.item;

import artifacts.item.wearable.WearableArtifactItem;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DeathEye
extends WearableArtifactItem {
    private static final int COOLDOWN_TICKS = 100;
    private static final double RANGE = 10.0;
    private static final String NBT_TARGET = "death_eye_target";
    private static final String NBT_MULTIPLIER = "death_eye_multiplier";

    protected String getTooltipItemName() {
        return "death_eye";
    }

    public boolean hasNonCosmeticEffects() {
        return true;
    }

    public void wornTick(LivingEntity entity, ItemStack stack) {
        boolean sameTarget;
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.isOnCooldown(entity)) {
            return;
        }
        LivingEntity target = this.getEntityInSight(player, 10.0);
        if (target == null || !target.m_6084_()) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        double multiplier = tag.m_128441_(NBT_MULTIPLIER) ? tag.m_128459_(NBT_MULTIPLIER) : 1.0;
        UUID targetId = target.m_20148_();
        boolean bl = sameTarget = tag.m_128403_(NBT_TARGET) && tag.m_128342_(NBT_TARGET).equals(targetId);
        multiplier = sameTarget ? (multiplier *= 1.25) : 1.0;
        float damage = (float)(1.0 * multiplier);
        target.m_6469_(entity.m_9236_().m_269111_().m_269075_(player), damage);
        tag.m_128362_(NBT_TARGET, targetId);
        tag.m_128347_(NBT_MULTIPLIER, multiplier);
        this.addCooldown(entity, 100);
    }

    private LivingEntity getEntityInSight(Player player, double range) {
        Vec3 eyePos = player.m_146892_();
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 endPos = eyePos.m_82549_(lookVec.m_82490_(range));
        AABB box = new AABB(eyePos, endPos).m_82400_(1.0);
        List entities = player.m_9236_().m_6443_(LivingEntity.class, box, e -> e != player && e.m_6084_());
        for (LivingEntity e2 : entities) {
            if (!e2.m_20191_().m_82371_(eyePos, endPos).isPresent()) continue;
            return e2;
        }
        return null;
    }
}

