/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatartifacts.compats.cataclysm.item;

import artifacts.item.wearable.WearableArtifactItem;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MetalClaws
extends WearableArtifactItem {
    public MetalClaws() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean hasNonCosmeticEffects() {
        return true;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        if (level.f_46443_) {
            return;
        }
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (!this.isEquippedBy((LivingEntity)player)) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Block block = state.m_60734_();
        boolean isLog = state.m_204336_(BlockTags.f_13106_);
        boolean isOre = state.m_204336_(Tags.Blocks.ORES);
        if (block instanceof CropBlock) {
            this.harvestCrops(level, pos, player);
            event.setCanceled(true);
            return;
        }
        if (isLog) {
            this.harvestCluster(level, pos, player, s -> s.m_204336_(BlockTags.f_13106_), 256);
        } else if (isOre) {
            this.harvestCluster(level, pos, player, s -> s.m_204336_(Tags.Blocks.ORES), 128);
        }
    }

    private void harvestCluster(Level level, BlockPos origin, Player player, Predicate<BlockState> matcher, int maxBlocks) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(origin);
        visited.add(origin);
        int processed = 0;
        while (!queue.isEmpty() && processed < maxBlocks) {
            BlockPos current = (BlockPos)queue.poll();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockState st;
                        BlockPos next = current.m_7918_(dx, dy, dz);
                        if (visited.contains(next) || !level.m_46749_(next) || !matcher.test(st = level.m_8055_(next))) continue;
                        visited.add(next);
                        queue.add(next);
                        if (next.equals((Object)origin)) continue;
                        level.m_46953_(next, true, (Entity)player);
                        if (++processed < maxBlocks) continue;
                        return;
                    }
                }
            }
        }
    }

    private void harvestCrops(Level level, BlockPos origin, Player player) {
        int radius = 8;
        int y = origin.m_123342_();
        for (int x = origin.m_123341_() - radius; x <= origin.m_123341_() + radius; ++x) {
            for (int z = origin.m_123343_() - radius; z <= origin.m_123343_() + radius; ++z) {
                CropBlock crop;
                BlockState state;
                Block block;
                BlockPos pos = new BlockPos(x, y, z);
                if (!level.m_46749_(pos) || !((block = (state = level.m_8055_(pos)).m_60734_()) instanceof CropBlock) || !(crop = (CropBlock)block).m_52307_(state)) continue;
                Block.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)ItemStack.f_41583_);
                level.m_7731_(pos, crop.m_52289_(0), 3);
            }
        }
    }
}

