/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatartifacts.compats.create.item;

import artifacts.item.ArtifactItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LongHand
extends ArtifactItem {
    private static final double EXTENDED_REACH_DISTANCE = 9.0;

    public LongHand() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean isCosmetic() {
        return false;
    }

    protected String getTooltipItemName() {
        return "long_hand";
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        ItemStack offhandItem = player.m_21206_();
        if (offhandItem.m_41720_() instanceof LongHand) {
            this.applyReachDistances(player, 9.0);
        } else {
            this.resetReachDistances(player);
        }
    }

    private void applyReachDistances(Player player, double distance) {
        AttributeInstance entityReach;
        AttributeInstance blockReach = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get());
        if (blockReach != null && blockReach.m_22115_() != distance) {
            blockReach.m_22100_(distance);
        }
        if ((entityReach = player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get())) != null && entityReach.m_22115_() != distance) {
            entityReach.m_22100_(distance);
        }
    }

    private void resetReachDistances(Player player) {
        AttributeInstance entityReach;
        AttributeInstance blockReach = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get());
        if (blockReach != null) {
            blockReach.m_22100_(blockReach.m_22099_().m_22082_());
        }
        if ((entityReach = player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get())) != null) {
            entityReach.m_22100_(entityReach.m_22099_().m_22082_());
        }
    }

    @SubscribeEvent
    public void onHit(LivingHurtEvent event) {
        Entity src = event.getSource().m_7639_();
        if (!(src instanceof Player)) {
            return;
        }
        Player player = (Player)src;
        if (!(player.m_21206_().m_41720_() instanceof LongHand)) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (!target.m_6084_()) {
            return;
        }
        double force = 4.5;
        Vec3 look = player.m_20154_();
        target.m_20334_(look.f_82479_ * force, (double)0.35f, look.f_82481_ * force);
        target.f_19812_ = true;
    }
}

