/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatartifacts.compats.ecologics.armor;

import net.fixerlink.compatartifacts.compats.ecologics.armor.CoconutArmorMaterials;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="compatartifacts")
public class CoconutArmorSetBonus {
    private static boolean hasFullCoconutSet(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        ItemStack head = entity.m_6844_(EquipmentSlot.HEAD);
        ItemStack chest = entity.m_6844_(EquipmentSlot.CHEST);
        ItemStack legs = entity.m_6844_(EquipmentSlot.LEGS);
        ItemStack feet = entity.m_6844_(EquipmentSlot.FEET);
        return CoconutArmorSetBonus.isCoconutPiece(head) && CoconutArmorSetBonus.isCoconutPiece(chest) && CoconutArmorSetBonus.isCoconutPiece(legs) && CoconutArmorSetBonus.isCoconutPiece(feet);
    }

    private static boolean isCoconutPiece(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return false;
        }
        ArmorItem armor = (ArmorItem)item;
        return armor.m_40401_() == CoconutArmorMaterials.COCONUT;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (!CoconutArmorSetBonus.hasFullCoconutSet(entity)) {
            return;
        }
        float amount = event.getAmount();
        if (amount <= 0.0f) {
            return;
        }
        event.setAmount(amount * 0.5f);
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (!CoconutArmorSetBonus.hasFullCoconutSet(entity)) {
            return;
        }
        for (ItemStack armorStack : entity.m_6168_()) {
            ArmorItem armor;
            Item item = armorStack.m_41720_();
            if (!(item instanceof ArmorItem) || (armor = (ArmorItem)item).m_40401_() != CoconutArmorMaterials.COCONUT || !armorStack.m_41763_() || armorStack.m_41773_() <= 0) continue;
            armorStack.m_41721_(0);
        }
    }
}

