/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatartifacts.compats.ecologics.item;

import artifacts.item.ArtifactItem;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class InfinityMoss
extends ArtifactItem {
    private static final int TICK_INTERVAL = 20;

    public InfinityMoss() {
        super(new Item.Properties().m_41487_(1));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean isCosmetic() {
        return false;
    }

    protected String getTooltipItemName() {
        return "infinity_moss";
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Block block;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (!this.hasInfinityMossInInventory(player)) {
            return;
        }
        if (player.f_19797_ % 20 != 0) {
            return;
        }
        if (level.m_5776_()) {
            return;
        }
        BlockPos posBelow = player.m_20183_().m_7495_();
        BlockState stateBelow = level.m_8055_(posBelow);
        if (stateBelow.m_60713_(Blocks.f_152544_) && (block = stateBelow.m_60734_()) instanceof BonemealableBlock) {
            BonemealableBlock bonemealable = (BonemealableBlock)block;
            bonemealable.m_214148_((ServerLevel)level, level.f_46441_, posBelow, stateBelow);
        }
    }

    private boolean hasInfinityMossInInventory(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!(stack.m_41720_() instanceof InfinityMoss)) continue;
            return true;
        }
        return false;
    }
}

