/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatartifacts.compats.farmersdelight.item;

import artifacts.item.ArtifactItem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class InterestingFood
extends ArtifactItem {
    private static final String FOOD_COPY_KEY = "FoodCopyId";
    private static final Random RANDOM = new Random();
    private static List<Item> FOOD_POOL = null;
    private static final int COOLDOWN_TICKS = 100;

    public InterestingFood() {
        super(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(0).m_38758_(0.0f).m_38765_().m_38767_()));
    }

    public boolean isCosmetic() {
        return false;
    }

    protected String getTooltipItemName() {
        return "interesting_food";
    }

    public Component m_7626_(ItemStack stack) {
        Item copied;
        String id;
        ResourceLocation rl;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(FOOD_COPY_KEY) && (rl = ResourceLocation.m_135820_((String)(id = tag.m_128461_(FOOD_COPY_KEY)))) != null && (copied = (Item)ForgeRegistries.ITEMS.getValue(rl)) != null) {
            return Component.m_237110_((String)"item.compatartifacts.interesting_food.named", (Object[])new Object[]{Component.m_237115_((String)copied.m_5524_())});
        }
        return super.m_7626_(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.isOnCooldown((LivingEntity)player)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.f_46443_ && entity instanceof Player) {
            FoodProperties foodProperties;
            Player player = (Player)entity;
            if (this.isOnCooldown((LivingEntity)player)) {
                return stack;
            }
            Item copiedFood = this.getRandomFoodItem();
            if (copiedFood != null && copiedFood.m_41472_() && (foodProperties = copiedFood.m_41473_()) != null) {
                player.m_36324_().m_38707_(foodProperties.m_38744_(), foodProperties.m_38745_());
                for (Pair effect : foodProperties.m_38749_()) {
                    if (!(RANDOM.nextFloat() < ((Float)effect.getSecond()).floatValue())) continue;
                    player.m_7292_(new MobEffectInstance((MobEffectInstance)effect.getFirst()));
                }
                ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)copiedFood);
                if (key != null) {
                    CompoundTag tag = stack.m_41784_();
                    tag.m_128359_(FOOD_COPY_KEY, key.toString());
                }
            }
            this.addCooldown((LivingEntity)player, 100);
        }
        return stack;
    }

    private Item getRandomFoodItem() {
        if (FOOD_POOL == null) {
            ArrayList<Item> items = new ArrayList<Item>();
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                if (!item.m_41472_()) continue;
                items.add(item);
            }
            if (items.isEmpty()) {
                items.add(Items.f_42406_);
                items.add(Items.f_42410_);
                items.add(Items.f_42580_);
            }
            FOOD_POOL = Collections.unmodifiableList(items);
        }
        if (FOOD_POOL.isEmpty()) {
            return null;
        }
        return FOOD_POOL.get(RANDOM.nextInt(FOOD_POOL.size()));
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(FOOD_COPY_KEY)) {
            String id = tag.m_128461_(FOOD_COPY_KEY);
            Item copied = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
            if (copied != null) {
                tooltip.add((Component)Component.m_237110_((String)"item.compatartifacts.interesting_food.copies", (Object[])new Object[]{Component.m_237115_((String)copied.m_5524_())}));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"item.compatartifacts.interesting_food.copies.unknown"));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.compatartifacts.interesting_food.copies.unknown"));
        }
    }
}

