/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatartifacts.compats.iceandfire.armor;

import net.fixerlink.compatartifacts.compats.iceandfire.armor.PhantasmalArmorMaterials;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="compatartifacts")
public class PhantasmalArmorSetBonus {
    private static boolean isPhantasmalPiece(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return false;
        }
        ArmorItem armor = (ArmorItem)item;
        return armor.m_40401_() == PhantasmalArmorMaterials.PHANTASMAL;
    }

    private static boolean hasFullPhantasmalSet(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        return PhantasmalArmorSetBonus.isPhantasmalPiece(entity.m_6844_(EquipmentSlot.HEAD)) && PhantasmalArmorSetBonus.isPhantasmalPiece(entity.m_6844_(EquipmentSlot.CHEST)) && PhantasmalArmorSetBonus.isPhantasmalPiece(entity.m_6844_(EquipmentSlot.LEGS)) && PhantasmalArmorSetBonus.isPhantasmalPiece(entity.m_6844_(EquipmentSlot.FEET));
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && PhantasmalArmorSetBonus.hasFullPhantasmalSet((LivingEntity)(player = (Player)livingEntity))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (PhantasmalArmorSetBonus.hasFullPhantasmalSet((LivingEntity)player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player != null && PhantasmalArmorSetBonus.hasFullPhantasmalSet((LivingEntity)player)) {
            event.setCanceled(true);
        }
    }
}

