/*
 * Decompiled with CFR 0.152.
 */
package net.fixerlink.compatartifacts.compats.tconstruct.item;

import artifacts.item.ArtifactItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class MobArtifact
extends ArtifactItem {
    private static final String TAG_ENTITY_TYPE = "compatartifacts.StoredEntityType";
    private static final String TAG_ENTITY_DATA = "compatartifacts.StoredEntityData";
    private static final int COOLDOWN_TICKS = 6000;

    public MobArtifact() {
        super(new Item.Properties().m_41487_(1));
    }

    public boolean isCosmetic() {
        return false;
    }

    private static boolean hasStoredEntity(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(TAG_ENTITY_TYPE);
    }

    public boolean m_5812_(ItemStack stack) {
        return MobArtifact.hasStoredEntity(stack) || super.m_5812_(stack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        Level level = player.m_9236_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (MobArtifact.hasStoredEntity(stack)) {
            return InteractionResult.PASS;
        }
        if (target instanceof Player) {
            return InteractionResult.PASS;
        }
        EntityType type = target.m_6095_();
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)type);
        if (id == null) {
            return InteractionResult.PASS;
        }
        CompoundTag entityTag = new CompoundTag();
        target.m_20240_(entityTag);
        entityTag.m_128473_("Pos");
        entityTag.m_128473_("Rotation");
        entityTag.m_128473_("Motion");
        entityTag.m_128473_("UUID");
        entityTag.m_128473_("UUIDMost");
        entityTag.m_128473_("UUIDLeast");
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(TAG_ENTITY_TYPE, id.toString());
        tag.m_128365_(TAG_ENTITY_DATA, (Tag)entityTag);
        target.m_146870_();
        return InteractionResult.CONSUME;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        if (level.f_46443_) {
            return MobArtifact.hasStoredEntity(stack) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (!MobArtifact.hasStoredEntity(stack)) {
            return InteractionResult.PASS;
        }
        if (this.isOnCooldown((LivingEntity)player)) {
            return InteractionResult.PASS;
        }
        Vec3 click = context.m_43720_();
        double x = click.f_82479_;
        double y = click.f_82480_;
        double z = click.f_82481_;
        if (this.releaseEntity(stack, level, x, y, z)) {
            this.addCooldown((LivingEntity)player, 6000);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        double z;
        double y;
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (!MobArtifact.hasStoredEntity(stack)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (this.isOnCooldown((LivingEntity)player)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        double x = player.m_20185_() + player.m_20154_().f_82479_ * 2.0;
        if (this.releaseEntity(stack, level, x, y = player.m_20186_() + (double)player.m_20192_() + player.m_20154_().f_82480_ * 2.0, z = player.m_20189_() + player.m_20154_().f_82481_ * 2.0)) {
            this.addCooldown((LivingEntity)player, 6000);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private boolean releaseEntity(ItemStack stack, Level level, double x, double y, double z) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(TAG_ENTITY_TYPE)) {
            return false;
        }
        String idStr = tag.m_128461_(TAG_ENTITY_TYPE);
        ResourceLocation id = new ResourceLocation(idStr);
        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id);
        if (type == null) {
            return false;
        }
        CompoundTag entityData = tag.m_128469_(TAG_ENTITY_DATA);
        Entity entity = type.m_20615_(level);
        if (entity == null) {
            return false;
        }
        entity.m_20258_(entityData);
        entity.m_7678_(x, y, z, entity.m_146908_(), entity.m_146909_());
        level.m_7967_(entity);
        tag.m_128473_(TAG_ENTITY_TYPE);
        tag.m_128473_(TAG_ENTITY_DATA);
        if (tag.m_128456_()) {
            stack.m_41751_(null);
        }
        return true;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (!MobArtifact.hasStoredEntity(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"item.compatartifacts.mob_artifact.empty").m_130940_(ChatFormatting.DARK_GRAY));
            return;
        }
        CompoundTag tag = stack.m_41784_();
        String idStr = tag.m_128461_(TAG_ENTITY_TYPE);
        ResourceLocation id = new ResourceLocation(idStr);
        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(id);
        if (type != null) {
            MutableComponent name = Component.m_237115_((String)type.m_20675_());
            tooltip.add((Component)Component.m_237110_((String)"item.compatartifacts.mob_artifact.contains", (Object[])new Object[]{name}).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237113_((String)idStr).m_130940_(ChatFormatting.GRAY));
        }
    }
}

