/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.blocks;

import com.bytemaniak.mcquake3.network.s2c.PickupVisibilityS2CPacket;
import com.bytemaniak.mcquake3.util.MiscUtils;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PickupEntity
extends class_2586
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final long regenTime;
    private long ticksSinceLastUse;
    public boolean lastShouldRender = true;
    private final class_3414 useSound;
    private final class_3414 regenSound;

    public PickupEntity(class_2591<? extends PickupEntity> type, class_2338 pos, class_2680 state, class_3414 useSound, class_3414 regenSound, float regenTime) {
        super(type, pos, state);
        this.useSound = useSound;
        this.regenSound = regenSound;
        this.regenTime = this.ticksSinceLastUse = (long)MiscUtils.toTicks(regenTime);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", state -> PlayState.CONTINUE).triggerableAnim("idle", DefaultAnimations.IDLE));
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
        this.triggerAnim("controller", "idle");
    }

    public boolean shouldRender() {
        return this.ticksSinceLastUse > this.regenTime;
    }

    public boolean use() {
        if (this.ticksSinceLastUse > this.regenTime) {
            this.ticksSinceLastUse = 0L;
            return true;
        }
        return false;
    }

    public void method_5431() {
        if (!this.field_11863.field_9236) {
            PickupVisibilityS2CPacket data = new PickupVisibilityS2CPacket(this.method_11016(), this.shouldRender());
            for (class_3222 plr : PlayerLookup.tracking((class_3218)((class_3218)this.field_11863), (class_2338)this.method_11016())) {
                ServerPlayNetworking.send((class_3222)plr, (class_8710)data);
            }
            super.method_5431();
        }
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        if (!world.field_9236) {
            PickupEntity pickupEntity = (PickupEntity)t;
            ++pickupEntity.ticksSinceLastUse;
            if (pickupEntity.lastShouldRender != pickupEntity.shouldRender()) {
                pickupEntity.method_5431();
                if (pickupEntity.shouldRender()) {
                    world.method_8396(null, pos, pickupEntity.regenSound, class_3419.field_15254, 1.0f, 1.0f);
                } else {
                    world.method_8396(null, pos, pickupEntity.useSound, class_3419.field_15254, 1.0f, 1.0f);
                }
            }
            pickupEntity.lastShouldRender = pickupEntity.shouldRender();
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10556("render", this.lastShouldRender);
        super.method_11007(nbt, registryLookup);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.lastShouldRender = nbt.method_10577("render");
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

