/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.data;

import com.bytemaniak.mcquake3.registry.ServerEvents;
import com.bytemaniak.mcquake3.registry.WorldKeys;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_18;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class QuakeArenasParameters
extends class_18 {
    public final List<ArenaData> arenas = new ArrayList<ArenaData>();
    public int activeArena = 0;
    private static class_18.class_8645<QuakeArenasParameters> type = new class_18.class_8645(QuakeArenasParameters::new, QuakeArenasParameters::readNbt, null);

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_2499 arenasNbt = new class_2499();
        for (ArenaData arena : this.arenas) {
            class_2487 arenaNbt = new class_2487();
            class_2499 spawnpoints = new class_2499();
            arenaNbt.method_10582("Arena_name", arena.arenaName);
            for (ArenaData.Spawnpoint i : arena.spawnpoints) {
                class_2487 spawnpoint = new class_2487();
                spawnpoint.method_10569("x", i.position.method_10263());
                spawnpoint.method_10569("y", i.position.method_10264());
                spawnpoint.method_10569("z", i.position.method_10260());
                spawnpoint.method_10548("yaw", i.yaw);
                spawnpoints.add((Object)spawnpoint);
            }
            arenaNbt.method_10566("spawnpoints", (class_2520)spawnpoints);
            arenasNbt.add((Object)arenaNbt);
        }
        nbt.method_10566("q3Arenas_data", (class_2520)arenasNbt);
        nbt.method_10569("active_Arena", this.activeArena);
        return nbt;
    }

    private static QuakeArenasParameters readNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        QuakeArenasParameters state = new QuakeArenasParameters();
        class_2499 arenasData = nbt.method_10554("q3Arenas_data", 10);
        for (int i = 0; i < arenasData.size(); ++i) {
            ArenaData arenaData = new ArenaData();
            class_2487 arenaDataNbt = arenasData.method_10602(i);
            arenaData.arenaName = arenaDataNbt.method_10558("Arena_name");
            class_2499 spawnpoints = arenaDataNbt.method_10554("spawnpoints", 10);
            for (int j = 0; j < spawnpoints.size(); ++j) {
                class_2487 spawnpointNbt = spawnpoints.method_10602(j);
                class_2338 position = new class_2338(spawnpointNbt.method_10550("x"), spawnpointNbt.method_10550("y"), spawnpointNbt.method_10550("z"));
                float yaw = spawnpointNbt.method_10583("yaw");
                arenaData.spawnpoints.add(new ArenaData.Spawnpoint(position, yaw));
            }
            state.arenas.add(arenaData);
        }
        state.activeArena = nbt.method_10550("active_Arena");
        return state;
    }

    public static QuakeArenasParameters getServerState(MinecraftServer server) {
        class_26 persistentStateManager = server.method_3847(WorldKeys.Q3_DIMENSION).method_17983();
        return (QuakeArenasParameters)persistentStateManager.method_17924(type, "mcquake3_Arenas");
    }

    public void createInitialArenaData(String arenaName) {
        if (this.getArena(arenaName) == null) {
            ArenaData arenaData = new ArenaData();
            arenaData.arenaName = arenaName;
            this.arenas.add(arenaData);
            this.method_80();
        }
    }

    public ArenaData getArena(String arenaName) {
        return this.arenas.stream().filter(e -> Objects.equals(e.arenaName, arenaName)).findFirst().orElse(null);
    }

    public ArenaData getRandomArena(String except) {
        if (this.arenas.isEmpty()) {
            return null;
        }
        if (this.arenas.size() == 1) {
            return this.arenas.getFirst();
        }
        ArenaData nextArena = this.arenas.get(ThreadLocalRandom.current().nextInt(this.arenas.size()));
        while (nextArena.arenaName.equals(except)) {
            nextArena = this.arenas.get(ThreadLocalRandom.current().nextInt(this.arenas.size()));
        }
        return nextArena;
    }

    public boolean addSpawnpoint(String arenaName, class_2338 spawnpoint, float yaw) {
        ArenaData arena = this.getArena(arenaName);
        if (arena == null) {
            return false;
        }
        arena.spawnpoints.add(new ArenaData.Spawnpoint(spawnpoint, yaw));
        this.method_80();
        ArenaData matchArena = ServerEvents.QUAKE_MATCH_STATE.arena;
        if (matchArena != null && arenaName.equals(matchArena.arenaName)) {
            ServerEvents.QUAKE_MATCH_STATE.arena = arena;
        }
        return true;
    }

    public void deleteSpawnpoint(String arenaName, class_2338 spawnpoint) {
        ArenaData arena = this.getArena(arenaName);
        if (arena == null) {
            return;
        }
        arena.spawnpoints.removeIf(a -> a.position.equals((Object)spawnpoint));
    }

    public void deleteArena(class_3218 world, String arenaName) {
        Optional<ArenaData> arena = this.arenas.stream().filter(a -> a.arenaName.equals(arenaName)).findFirst();
        if (arena.isEmpty()) {
            return;
        }
        ArenaData arenaData = arena.get();
        ArrayList<ArenaData.Spawnpoint> spawnpoints = new ArrayList<ArenaData.Spawnpoint>(arenaData.spawnpoints);
        for (ArenaData.Spawnpoint spawnpoint : spawnpoints) {
            world.method_8501(spawnpoint.position, class_2246.field_10124.method_9564());
        }
        this.arenas.remove(arenaData);
        this.method_80();
        ArenaData matchArena = ServerEvents.QUAKE_MATCH_STATE.arena;
        if (matchArena != null && arenaName.equals(matchArena.arenaName)) {
            ServerEvents.QUAKE_MATCH_STATE.arena = this.getRandomArena(null);
        }
    }

    public static class ArenaData {
        public String arenaName;
        public final List<Spawnpoint> spawnpoints = new ArrayList<Spawnpoint>();

        public record Spawnpoint(class_2338 position, float yaw) {
        }
    }
}

