/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.entity;

import com.bytemaniak.mcquake3.entity.PropEntity;
import com.bytemaniak.mcquake3.interfaces.MultiCollidable;
import com.bytemaniak.mcquake3.network.c2s.JumppadSoundC2SPacket;
import com.bytemaniak.mcquake3.registry.Blocks;
import com.bytemaniak.mcquake3.registry.Sounds;
import com.bytemaniak.mcquake3.registry.Weapons;
import com.bytemaniak.mcquake3.screen.JumppadScreenHandler;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_8710;
import software.bernie.geckolib.animatable.GeoEntity;

public class JumppadEntity
extends PropEntity
implements GeoEntity,
ExtendedScreenHandlerFactory,
MultiCollidable {
    protected static final class_2940<Byte> POWER = class_2945.method_12791(JumppadEntity.class, (class_2941)class_2943.field_13319);
    protected static final class_2940<Byte> FACING = class_2945.method_12791(JumppadEntity.class, (class_2941)class_2943.field_13319);
    private static final int JUMPPAD_BOOST_SOUND_TICKS_COOLDOWN = 10;
    private long lastTick = 0L;

    public JumppadEntity(class_1299<JumppadEntity> entityType, class_1937 world) {
        this((class_1299<? extends JumppadEntity>)entityType, world, Blocks.JUMPPAD_ITEM);
    }

    protected JumppadEntity(class_1299<? extends JumppadEntity> entityType, class_1937 world, class_1792 droppedItem) {
        super(entityType, world, droppedItem);
    }

    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        JumppadData data = new JumppadData(this.getPower(), this.method_5628());
        return new JumppadScreenHandler(syncId, inv, data);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(POWER, (Object)0);
        builder.method_56912(FACING, (Object)((byte)class_2350.field_11036.method_10146()));
    }

    public void method_5749(class_2487 nbt) {
        this.field_6011.method_12778(POWER, (Object)nbt.method_10571("power"));
        this.setFacing(class_2350.method_10143((int)nbt.method_10571("facing")));
    }

    public void method_5652(class_2487 nbt) {
        nbt.method_10567("power", ((Byte)this.field_6011.method_12789(POWER)).byteValue());
        nbt.method_10567("facing", ((Byte)this.field_6011.method_12789(FACING)).byteValue());
    }

    public JumppadData getScreenOpeningData(class_3222 player) {
        return new JumppadData(this.getPower(), this.method_5628());
    }

    @Override
    public List<class_265> getColliders() {
        ArrayList<class_265> colliders = new ArrayList<class_265>();
        class_2338 pos = this.method_24515();
        double horizStep = 0.3125;
        double heightStep = 0.20833333333333334;
        double x = (double)pos.method_10263() - 0.4375;
        double y = pos.method_10264();
        double z = (double)pos.method_10260() - 0.4375;
        switch (this.method_58149()) {
            case field_11036: {
                colliders.add(class_259.method_1081((double)x, (double)y, (double)z, (double)(x + 1.875), (double)(y + 0.20833333333333334), (double)(z + 1.875)));
                break;
            }
            case field_11043: {
                for (int i = 0; i < 6; ++i) {
                    colliders.add(class_259.method_1081((double)x, (double)y, (double)z, (double)(x + 1.875), (double)(y + 0.20833333333333334), (double)(z + 0.3125)));
                    z += 0.3125;
                    y += 0.20833333333333334;
                }
                break;
            }
            case field_11034: {
                y += 1.0416666666666667;
                for (int i = 0; i < 6; ++i) {
                    colliders.add(class_259.method_1081((double)x, (double)y, (double)z, (double)(x + 0.3125), (double)(y + 0.20833333333333334), (double)(z + 1.875)));
                    x += 0.3125;
                    y -= 0.20833333333333334;
                }
                break;
            }
            case field_11035: {
                y += 1.0416666666666667;
                for (int i = 0; i < 6; ++i) {
                    colliders.add(class_259.method_1081((double)x, (double)y, (double)z, (double)(x + 1.875), (double)(y + 0.20833333333333334), (double)(z + 0.3125)));
                    z += 0.3125;
                    y -= 0.20833333333333334;
                }
                break;
            }
            case field_11039: {
                for (int i = 0; i < 6; ++i) {
                    colliders.add(class_259.method_1081((double)x, (double)y, (double)z, (double)(x + 0.3125), (double)(y + 0.20833333333333334), (double)(z + 1.875)));
                    x += 0.3125;
                    y += 0.20833333333333334;
                }
                break;
            }
        }
        return colliders;
    }

    public class_243 getVelocityVector() {
        class_243 v = class_243.method_1030((float)(this.method_36455() - 90.0f), (float)this.method_36454());
        v = v.method_1021((double)this.getPower());
        v = v.method_18805(1.0, 1.0 / Math.sqrt(v.field_1351), 1.0);
        return v;
    }

    public void method_5694(class_1657 player) {
        if (this.getPower() > 0) {
            class_1937 world;
            class_238 playerBox = player.method_5829().method_1014((double)0.1f);
            class_238 box = null;
            boolean intersectsAny = false;
            for (class_265 shape : this.getColliders()) {
                box = shape.method_1107();
                if (!playerBox.method_994(box)) continue;
                intersectsAny = true;
                break;
            }
            if (intersectsAny && playerBox.field_1322 >= box.field_1322 && (world = this.method_37908()).method_8510() - this.lastTick > 10L) {
                this.lastTick = this.method_37908().method_8510();
                if (world.field_9236) {
                    class_243 v = this.getVelocityVector();
                    player.method_24830(false);
                    player.method_60491(v);
                    player.field_6037 = true;
                    world.method_8396(player, this.method_24515(), Sounds.JUMPPAD_BOOST, class_3419.field_15245, 1.0f, 1.0f);
                    JumppadSoundC2SPacket buf = new JumppadSoundC2SPacket(this.method_24515());
                    ClientPlayNetworking.send((class_8710)buf);
                }
            }
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!player.method_5998(hand).method_31574(Weapons.TOOL)) {
            return class_1269.field_5814;
        }
        if (player.method_5715()) {
            class_2350 facing = class_2350.method_10143((int)((Byte)this.field_6011.method_12789(FACING)).byteValue());
            facing = facing == class_2350.field_11036 ? class_2350.field_11043 : (facing == class_2350.field_11039 ? class_2350.field_11036 : facing.method_10170());
            this.setFacing(facing);
        } else {
            player.method_17355((class_3908)this);
        }
        return class_1269.field_5812;
    }

    public void setFacing(class_2350 direction) {
        this.field_6011.method_12778(FACING, (Object)((byte)direction.method_10146()));
        if (direction != class_2350.field_11036) {
            this.method_36457(35.0f);
            this.method_36456(direction.method_10161() * 90);
        } else {
            this.method_36457(0.0f);
            this.method_36456(0.0f);
        }
    }

    public class_2350 method_58149() {
        return class_2350.method_10143((int)((Byte)this.field_6011.method_12789(FACING)).byteValue());
    }

    public void updatePower(byte power) {
        this.field_6011.method_12778(POWER, (Object)power);
    }

    public byte getPower() {
        return (Byte)this.field_6011.method_12789(POWER);
    }

    public record JumppadData(byte power, int id) {
    }
}

