/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.entity.projectile;

import com.bytemaniak.mcquake3.entity.projectile.SimpleProjectile;
import com.bytemaniak.mcquake3.registry.Entities;
import com.bytemaniak.mcquake3.registry.Particles;
import com.bytemaniak.mcquake3.registry.Q3DamageSources;
import com.bytemaniak.mcquake3.registry.Sounds;
import com.bytemaniak.mcquake3.sound.TrackedSound;
import com.bytemaniak.mcquake3.util.MiscUtils;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2604;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_8110;

public class BFG10KProjectile
extends SimpleProjectile {
    private static final float BFG10K_DAMAGE = MiscUtils.toMCDamage(100.0f);
    private static final float BFG10K_SPLASH_RADIUS = 4.0f;

    public BFG10KProjectile(class_1299<? extends SimpleProjectile> entityType, class_1937 world) {
        super(entityType, world, BFG10K_DAMAGE, Q3DamageSources.BFG10K_DAMAGE, Q3DamageSources.BFG10K_DAMAGE_SELF, 75);
    }

    public BFG10KProjectile(class_1937 world) {
        this((class_1299<? extends SimpleProjectile>)Entities.BFG10K_PROJECTILE, world);
    }

    @Environment(value=EnvType.CLIENT)
    private void playSound() {
        TrackedSound flyingSound = new TrackedSound((class_1297)this, Sounds.PLASMABALL_FLYING);
        class_310.method_1551().method_1483().method_4873((class_1113)flyingSound);
    }

    public void method_31471(class_2604 packet) {
        if (this.method_37908().field_9236) {
            this.playSound();
        }
        super.method_31471(packet);
    }

    @Override
    protected void onCollision2(class_239 hitResult) {
        if (!this.method_37908().field_9236) {
            this.method_37908().method_45447(null, this.method_24515(), Sounds.PLASMABALL_HIT, class_3419.field_15254);
            this.despawn();
        }
    }

    protected class_2394 method_7467() {
        return class_2398.field_29644;
    }

    @Override
    protected void despawn() {
        double x = this.method_23317() - 4.0;
        double y = this.method_23318() - 4.0;
        double z = this.method_23321() - 4.0;
        List entities = this.method_37908().method_8333((class_1297)this, new class_238(x, y, z, x + 8.0, y + 8.0, z + 8.0), e -> e instanceof class_1309);
        for (class_1297 entity : entities) {
            class_1282 source = entity == this.method_24921() ? Q3DamageSources.of(this.method_37908(), (class_5321<class_8110>)this.damageTypeSelf, (class_1297)this, this.method_24921()) : Q3DamageSources.of(this.method_37908(), (class_5321<class_8110>)this.damageType, (class_1297)this, this.method_24921());
            float exposure = 1.0f - Math.min(entity.method_5739((class_1297)this) / 4.0f, 1.0f);
            entity.method_5643(source, BFG10K_DAMAGE * exposure);
        }
        ((class_3218)this.method_37908()).method_14199((class_2394)Particles.BFG_PLASMA, this.method_23317(), this.method_23318(), this.method_23321(), 70, 0.0, 0.0, 0.0, 0.2);
        super.despawn();
    }
}

