/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.gui;

import com.bytemaniak.mcquake3.network.c2s.AddMedalC2SPacket;
import com.bytemaniak.mcquake3.registry.Sounds;
import com.bytemaniak.mcquake3.sound.SoundUtils;
import com.bytemaniak.mcquake3.util.MiscUtils;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8710;
import net.minecraft.class_9779;

public class FeedbackManager
implements HudRenderCallback {
    private static final long MEDAL_UPDATE_RATE = MiscUtils.toTicks(3.0f);
    private final CopyOnWriteArrayList<Medal> medals = new CopyOnWriteArrayList();
    private Medal currentMedal = null;
    private long lastUpdateTick = 0L;
    private static final long FRAG_TIME_THRESHOLD = MiscUtils.toTicks(2.0f);
    private long killTick = 0L;
    private int killCount = 0;
    private int gauntletKills = 0;
    public boolean lastHitRailgun = false;
    private int railHitCount = 0;

    private void addMedal(MedalType medal, int value, int ch) {
        this.medals.add(new Medal(medal, value, ch));
        AddMedalC2SPacket buf = new AddMedalC2SPacket(medal.value);
        ClientPlayNetworking.send((class_8710)buf);
    }

    public void pushEvent(Event ev, boolean arg) {
        long currentTick = class_310.method_1551().field_1687.method_8510();
        switch (ev.ordinal()) {
            case 0: {
                long prevKillTick = this.killTick;
                this.killTick = currentTick;
                if (this.killTick - prevKillTick <= FRAG_TIME_THRESHOLD) {
                    ++this.killCount;
                    this.addMedal(MedalType.EXCELLENT, this.killCount, 65530);
                }
                if (!arg) break;
                ++this.gauntletKills;
                this.addMedal(MedalType.GAUNTLET, this.gauntletKills, 65532);
                break;
            }
            case 1: {
                if (this.lastHitRailgun && arg) {
                    ++this.railHitCount;
                    this.addMedal(MedalType.IMPRESSIVE, this.railHitCount, 65531);
                }
                this.lastHitRailgun = arg;
            }
        }
    }

    private void renderCurrentMedal(class_332 context) {
        if (this.currentMedal == null) {
            return;
        }
        class_1041 window = class_310.method_1551().method_22683();
        String medal = Character.toString(this.currentMedal.ch).repeat(Math.min(this.currentMedal.count, 8));
        MiscUtils.drawText(context, medal, window.method_4486() / 2 - medal.length() * 16, window.method_4502() / 15, 0xFFFFFF);
    }

    public void onHudRender(class_332 context, class_9779 tickCounter) {
        long currentTick = class_310.method_1551().field_1687.method_8510();
        if (currentTick - this.lastUpdateTick > MEDAL_UPDATE_RATE) {
            if (this.medals.isEmpty()) {
                this.currentMedal = null;
            } else {
                this.lastUpdateTick = currentTick;
                this.currentMedal = this.medals.remove(0);
                switch (this.currentMedal.type.ordinal()) {
                    case 0: {
                        SoundUtils.playSoundLocally(Sounds.EXCELLENT);
                        break;
                    }
                    case 1: {
                        SoundUtils.playSoundLocally(Sounds.IMPRESSIVE);
                        break;
                    }
                    case 2: {
                        SoundUtils.playSoundLocally(Sounds.GAUNTLET);
                    }
                }
            }
        }
        this.renderCurrentMedal(context);
    }

    private record Medal(MedalType type, int count, int ch) {
    }

    private static enum MedalType {
        EXCELLENT(1),
        IMPRESSIVE(2),
        GAUNTLET(3);

        public final byte value;

        private MedalType(int value) {
            this.value = (byte)value;
        }
    }

    public static enum Event {
        PLAYER_KILL,
        WEAPON_HIT;

    }
}

