/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.items;

import com.bytemaniak.mcquake3.blocks.SpawnpointEntity;
import com.bytemaniak.mcquake3.data.QuakeArenasParameters;
import com.bytemaniak.mcquake3.interfaces.QuakePlayer;
import com.bytemaniak.mcquake3.registry.Blocks;
import com.bytemaniak.mcquake3.registry.WorldKeys;
import com.bytemaniak.mcquake3.screen.ArenaBrowserScreen;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_437;

public class ArenaTool
extends class_1792 {
    public ArenaTool() {
        super(new class_1792.class_1793().method_7889(1));
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        tooltip.add(class_2561.method_30163((String)"Used to describe properties of Quake3 arenas such as"));
        tooltip.add(class_2561.method_30163((String)"the name of the arena, and the spawnpoints located"));
        tooltip.add(class_2561.method_30163((String)"within this arena."));
        tooltip.add(class_2561.method_30163((String)"This tool will only function inside the Quake3 dimension."));
    }

    @Environment(value=EnvType.CLIENT)
    private void openArenaBrowser() {
        class_310.method_1551().method_1507((class_437)new ArenaBrowserScreen(class_2561.method_30163((String)"Arena browser")));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (world.field_9236 && !user.method_5715()) {
            this.openArenaBrowser();
            return class_1271.method_22427((Object)stack);
        }
        if (!world.method_40134().method_40225(WorldKeys.Q3_DIMENSION_TYPE)) {
            class_3222 player = (class_3222)user;
            class_3218 quakeDimension = player.field_13995.method_3847(WorldKeys.Q3_DIMENSION);
            ((QuakePlayer)user).mcquake3$sampleLastVanillaData();
            player.method_14251(quakeDimension, 0.0, 64.0, 0.0, 0.0f, 0.0f);
            player.method_7336(class_1934.field_9220);
            player.method_7353(class_2561.method_30163((String)"Moved to Quake3 dimension. Have fun building arenas!"), true);
            return class_1271.method_22427((Object)stack);
        }
        QuakePlayer player = (QuakePlayer)user;
        String arenaName = player.mcquake3$getCurrentlyEditingArena();
        if (user.method_5715()) {
            class_2350 dir;
            float yaw;
            class_2338 spawnpoint;
            boolean added;
            if (arenaName.isEmpty()) {
                user.method_7353(class_2561.method_30163((String)"No arena chosen yet"), true);
                return class_1271.method_22430((Object)stack);
            }
            QuakeArenasParameters state = QuakeArenasParameters.getServerState(((class_3218)world).method_8503());
            if (state.getArena(arenaName) == null) {
                state.createInitialArenaData(arenaName);
            }
            if (added = state.addSpawnpoint(arenaName, spawnpoint = user.method_24515(), yaw = (dir = class_2350.method_10150((double)user.method_36454())).method_10144())) {
                world.method_8501(spawnpoint, Blocks.SPAWNPOINT_BLOCK.method_9564());
                class_2586 entity = world.method_8321(spawnpoint);
                if (entity instanceof SpawnpointEntity) {
                    SpawnpointEntity spawnpointEntity = (SpawnpointEntity)entity;
                    spawnpointEntity.arenaName = arenaName;
                    spawnpointEntity.yaw = yaw;
                    user.method_7353(class_2561.method_30163((String)("Added spawnpoint " + spawnpoint.method_23854() + ", " + dir.method_15434() + " to arena '" + arenaName + "'")), true);
                }
            } else {
                user.method_7353(class_2561.method_30163((String)"Failed to add spawnpoint. Maybe the arena got deleted?"), true);
            }
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22427((Object)stack);
    }
}

