/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.items.weapons;

import com.bytemaniak.mcquake3.items.weapons.Weapon;
import com.bytemaniak.mcquake3.registry.Q3DamageSources;
import com.bytemaniak.mcquake3.registry.Q3StatusEffects;
import java.util.ArrayList;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4051;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_8110;

public abstract class HitscanWeapon
extends Weapon {
    private static final float HITSCAN_RADIUS = 0.1f;
    private static final float HITSCAN_VERTICAL_OFFSET = 0.3f;
    private final float damageAmount;
    private final class_5321<class_8110> damageType;
    private final float hitscanRange;
    private final float hitscanNumSteps;
    private final boolean pierceTarget;

    protected HitscanWeapon(class_2960 id, long refireRateQ3InTicks, long refireRateQLInTicks, boolean hasRepeatedFiringSound, class_3414 firingSound, boolean hasActiveLoopSound, float damageAmount, class_5321<class_8110> damageType, float hitscanRange, float hitscanStepDistance, class_1792 ammoType, int startingAmmo, int ammoBoxCount, int slot, boolean pierceTarget) {
        super(id, refireRateQ3InTicks, refireRateQLInTicks, hasRepeatedFiringSound, firingSound, hasActiveLoopSound, ammoType, startingAmmo, ammoBoxCount, slot);
        this.damageAmount = damageAmount;
        this.damageType = damageType;
        this.hitscanRange = hitscanRange;
        this.hitscanNumSteps = hitscanRange / hitscanStepDistance;
        this.pierceTarget = pierceTarget;
    }

    protected HitscanWeapon(class_2960 id, long refireRateQ3InTicks, long refireRateQLInTicks, boolean hasRepeatedFiringSound, class_3414 firingSound, boolean hasActiveLoopSound, float damageAmount, class_5321<class_8110> damageType, float hitscanRange, class_1792 ammoType, int startingAmmo, int ammoBoxCount, int slot, boolean pierceTarget) {
        this(id, refireRateQ3InTicks, refireRateQLInTicks, hasRepeatedFiringSound, firingSound, hasActiveLoopSound, damageAmount, damageType, hitscanRange, 0.25f, ammoType, startingAmmo, ammoBoxCount, slot, pierceTarget);
    }

    protected void onProjectileCollision(class_1937 world, class_1309 user, class_243 userPos, class_243 iterPos, class_243 upVec, boolean isBlockCollision) {
    }

    protected void onDamage(class_1937 world, class_1309 attacked) {
    }

    @Override
    protected void onWeaponRefire(class_1937 world, class_1309 user, class_1799 stack, class_243 lookDir, class_243 weaponPos) {
        class_243 eyePos = user.method_33571();
        class_243 destPos = eyePos.method_1019(lookDir.method_1021((double)this.hitscanRange));
        class_243 step = destPos.method_1020(weaponPos).method_1021((double)(1.0f / this.hitscanNumSteps));
        class_243 pos = weaponPos;
        class_243 upDir = class_243.method_1030((float)(user.method_36455() + 90.0f), (float)user.method_36454());
        class_243 offsetWeaponPos = weaponPos.method_1019(upDir.method_1021((double)0.3f));
        boolean isBlockCollision = true;
        ArrayList<class_1309> collidedWith = new ArrayList<class_1309>();
        int i = 0;
        while ((float)i < this.hitscanNumSteps) {
            class_238 blockCollisionBox;
            class_265 collisionShape;
            pos = pos.method_1019(step);
            class_243 minPos = pos.method_1019(new class_243((double)-0.1f, (double)-0.1f, (double)-0.1f));
            class_243 maxPos = pos.method_1019(new class_243((double)0.1f, (double)0.1f, (double)0.1f));
            class_2382 posI = new class_2382((int)Math.floor(pos.field_1352), (int)Math.floor(pos.field_1351), (int)Math.floor(pos.field_1350));
            class_2338 blockPos = new class_2338(posI);
            class_238 collisionBox = new class_238(minPos, maxPos);
            class_1309 collided = world.method_21726(class_1309.class, class_4051.field_18092, user, eyePos.field_1352, eyePos.field_1351, eyePos.field_1350, collisionBox);
            if (collided != null) {
                if (!world.field_9236) {
                    float damage = user.method_6059(class_7923.field_41174.method_47983((Object)Q3StatusEffects.QUAD_DAMAGE)) ? this.damageAmount * 3.0f : this.damageAmount;
                    class_1282 damageSource = Q3DamageSources.of(world, this.damageType, (class_1297)user, (class_1297)user);
                    if (!this.pierceTarget || !collidedWith.contains(collided)) {
                        collided.method_5643(damageSource, damage);
                    }
                    this.onDamage(world, collided);
                    if (this.pierceTarget) {
                        collidedWith.add(collided);
                    }
                }
                if (!this.pierceTarget) {
                    this.onProjectileCollision(world, user, offsetWeaponPos, pos, upDir, false);
                    return;
                }
                isBlockCollision = false;
            }
            if (world.method_22340(blockPos) && (collisionShape = world.method_8320(blockPos).method_26220((class_1922)world, blockPos)) != class_259.method_1073() && (blockCollisionBox = collisionShape.method_1107().method_996(blockPos)).method_994(collisionBox)) {
                this.onProjectileCollision(world, user, offsetWeaponPos, pos, upDir, isBlockCollision);
                return;
            }
            ++i;
        }
        this.onProjectileCollision(world, user, offsetWeaponPos, pos, upDir, isBlockCollision);
    }
}

