/*
 * Decompiled with CFR 0.152.
 */
package com.bytemaniak.mcquake3.items.weapons;

import com.bytemaniak.mcquake3.items.weapons.HitscanWeapon;
import com.bytemaniak.mcquake3.items.weapons.Weapon;
import com.bytemaniak.mcquake3.registry.Q3DamageSources;
import com.bytemaniak.mcquake3.registry.Sounds;
import com.bytemaniak.mcquake3.registry.Weapons;
import com.bytemaniak.mcquake3.registry.client.Renderers;
import com.bytemaniak.mcquake3.util.MiscUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;

public class LightningGun
extends HitscanWeapon {
    private static final long LIGHTNING_REFIRE_RATE = 1L;
    private static final float LIGHTNING_DAMAGE = MiscUtils.toMCDamage(8.0f);
    private static final float LIGHTNING_RANGE = 30.0f;

    public LightningGun() {
        super(class_2960.method_60654((String)"mcquake3:lightning_gun"), 1L, 1L, false, null, true, LIGHTNING_DAMAGE, Q3DamageSources.LIGHTNING_DAMAGE, 30.0f, Weapons.LIGHTNING_CELL, 100, 60, 5, false);
    }

    @Override
    protected void onDamage(class_1937 world, class_1309 attacked) {
        class_1548 creeper;
        if (attacked instanceof class_1548 && !(creeper = (class_1548)attacked).method_6872()) {
            world.method_43129(null, (class_1297)creeper, class_3417.field_14956, class_3419.field_15254, 1.0f, 1.0f);
            creeper.method_5800((class_3218)world, null);
        }
        world.method_43129(null, (class_1297)attacked, Sounds.LIGHTNING_HIT, class_3419.field_15254, 0.5f, 1.0f);
    }

    @Override
    protected void onWeaponRefire(class_1937 world, class_1309 user, class_1799 stack, class_243 lookDir, class_243 weaponPos) {
        if (user.method_5869()) {
            class_1282 selfDamage = Q3DamageSources.of(world, Q3DamageSources.LIGHTNING_DAMAGE_SELF, (class_1297)user, (class_1297)user);
            user.method_5643(selfDamage, LIGHTNING_DAMAGE * 3.0f);
            this.onDamage(world, user);
        } else {
            super.onWeaponRefire(world, user, stack, lookDir, weaponPos);
        }
    }

    @Override
    protected void onProjectileCollision(class_1937 world, class_1309 user, class_243 userPos, class_243 iterPos, class_243 upVec, boolean isBlockCollision) {
        if (world.field_9236) {
            this.submitLightningGunTrail(user, userPos, iterPos, upVec);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void submitLightningGunTrail(class_1309 user, class_243 startPos, class_243 endPos, class_243 upVec) {
        Renderers.trailRenderer.addTrail(startPos, endPos, upVec, user.method_5667(), this.slot);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (user.method_7337() || user.method_31548().method_7395(new class_1799((class_1935)Weapons.LIGHTNING_CELL)) > -1) {
            world.method_43129(null, (class_1297)user, Sounds.LIGHTNING_FIRE, class_3419.field_15248, 1.0f, 1.0f);
        }
        return super.method_7836(world, user, hand);
    }

    @Override
    public PlayState handle(AnimationState<Weapon> state) {
        return null;
    }
}

